/*****************************************************************/
/* ਬ ᯮ짮 ATAPI-CD   ந뢠 ᪮  */
/*  ᯮ짮 ࠩ		           		 */
/* ਫ  㬥樨  ATAPI-CD			 */
/* : BC 3.1, large model				 */
/*  _ࠩ_  . .. 設⢮ ਢ ⠭*/
/*  ࠡ  뢠,  । ஡ */
/* ࠡ  . ଠ  ஡,   ࠧ묨*/
/* ਢ 㤥 祭 業  ᮧ ᨨ,              */
/* ࠡᯮᮡ    襬 ⢥ ன.	 */
/*****************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <conio.h>


typedef unsigned char  byte;
typedef unsigned int   word;
typedef unsigned long dword;


/* ⥫ IDE-ன⢠ */
typedef struct{
int port;	/*  				*/
char irq;	/*  IRQ 1-15, ᫨  - 0 */
char ms;	/* 1 - , 0 - 		*/
}ATAPos;


/* ᫨ ᯮ 㣨 뢠
	⠡  ஢	*/
static ATAPos Atp[]={
{0x1F0,14,1},
{0x1F0,14,0},
{0x170,15,1},
{0x170,15,0},
{0x1E0,10,1},
{0x1E0,10,0},
{0x168,11,1},
{0x168,11,0},
{0,0,0}};

/* ,  ᫥ ࠧ ⠫  1x7 */
static byte Last1X7=0;

/*static ATAPos *GetDescr(int drvnum){return(Atp+drvnum);}*/

void StoreLBAToMSF(long lba, void *msf)
{
byte *msfb=msf;
lba+=150;
*msfb++=lba/(60L*75L);
lba%=(60L*75l);
*msfb++=lba/75L;
*msfb++=lba%75L;
}


word  GetMSBWord(word cd){return(
			(cd >> 8)|
			(cd << 8));}

dword GetMSBDword(dword cd){return(
			((cd >> 24)&0x000000FFL)|
			((cd >>  8)&0x0000FF00L)|
			((cd <<  8)&0x00FF0000L)|
			((cd << 24)&0xFF000000L));}

/*  ⠭  */
int WtBitMask(int port, int and, int wt, int sec)
{
long counter;
for(counter=sec*1000L;counter>0;counter--){
	int i;
	i=inportb(port);
	if((port&7)==7)	Last1X7=i;
	if((i&and)==wt) return(0);
	delay(1);
}
return(1);
}

/* ந  */
int ResetDrive(int port)
{
int i;
outportb(port+7,8); 	/* ணࠬ  */
outportb(port+0x206,0xe); /*   */
delay(10);
outportb(port+0x206,8);
delay(10);
for(i=0;i<200;i++)
	if((inportb(port+7)&0x88)==0)return(0);
	else delay(10);
return(1);
}


/*    <maxdetect> ATAPI-cd 
  ⥫  ⠡ DrvTbl*/
int FindAtapiCD(int maxdetect, int *DrvTbl)
{
int devnum;
int totaldev=0;
for(devnum=0;(Atp[devnum].port!=0)&&(totaldev<=maxdetect);devnum++){
	register int port=Atp[devnum].port;
	int i;
	/*  ன⢠ */
	outportb(port+6,Atp[devnum].ms?0xA0:0xB0);
	delay(1);
	if(inportb(port+7)==0xFF)continue;
	if(inportb(port+7)&0x80){
		/* ..  ? */
		if(ResetDrive(port))continue;
	}
	outportb(port+4,0);
	outportb(port+5,0);
	outportb(port+7,0xEC);
	for(i=0;i<20;i++){
		delay(1);
		if((inportb(port+4)==0x14)&&
		   (inportb(port+5)==0xEB)){
			word devcode;
			/*  ATAPI-ன⢮, 㥬 ஡ */
			delay(1);
			outportb(port+7,0xA1);
			for(i=0;i<100;i++)
				if(inport(port+7)&0x80)delay(1);
				else goto okcont;
			goto cont;

			okcont:
			delay(10);
			devcode=inport(port);
			for(i=0;i<255;i++)inport(port);
			/*  CD ? */
			if((devcode&0x1F00)!=0x500)break;
			/*   12   AP ? */
			if(devcode&1)break;
			*DrvTbl++=devnum;
			totaldev++;
			break;
		   }
	}
	cont:;
}
return(totaldev);
}


/*  뢠 -  㬭 cd-ࠩ  蠫 */
int DsbIrq(int devnum)
{
int inum=Atp[devnum].irq;
int oldst;
if(inum==0)return(0);
if(inum>=8){
	oldst=inportb(0xA1);
	outportb(0xA1,oldst|(1<<(inum-8)));
	return(!(oldst&(1<<(inum-8))));
}
oldst=inportb(0x21);
outportb(0x21,oldst|(1<<(inum)));
return(!(oldst&(1<<(inum))));
}

/* ࠧ 뢠  cd -  襭 ࠡ */
void EndIrq(int devnum)
{
int inum=Atp[devnum].irq;
if(inum==0)return;
if(inum>=8){
	outportb(0xA1,
		inportb(0xA1)&(~(1<<(inum-8))));
}
else{
	outportb(0x21,
	inportb(0x21)&(~(1<<inum)));
}
}

/* 믮 ATAPI-:
	 drive 	- ன⢮
	 dir    - 1 - ⥭, 0 -    CDD
	 AP 	-   ATAPI-⮬
	 buffer -   묨 (NULL, ᫨  㦥)
	 bufflen-  뢮   . ࠧ 
 室:
	 -1	- 뫠 訡
	 祥 - ࠧ ᫠  ( )
*/
static word PrefIOBlock=0x8000;  /* ࠧ  뫪  ᫮ */
static byte DontResetFlg=0;	/*  뢠  ⮢ */

int ExecATAPICMD(int drive, int dir, word *AP, word *buffer, word bufflen)
{
int port;
int i;
int readed=0;
int size;
	port=Atp[drive].port;
	/* 롥६ ⨢ ன⢮ */
	outportb(port+6,Atp[drive].ms?0xA0:0xB0);

	rerd:

	Last1X7=inportb(port+7);
	if(Last1X7&0x88){ /*  祭 ⮢ - ஡㥬 ࠢ  */
		if(DontResetFlg)return(-1);
		ResetDrive(port);
		/*  襭   */
		if(WtBitMask(port+7,0x80,0x0,10))return(-1);	/*  ⮢ */
		goto rerd;
	}
	/* ⠭ ࠧ  */
	{
	 register word pl;

	 if(PrefIOBlock>bufflen)pl=bufflen;
	 else 			pl=PrefIOBlock;
	 outportb(port+4,pl);
	 outportb(port+5,pl>>8);
	}
	/* ⨬ 直   */
	outportb(port+1,0);
	/*  ⮢  ࠡ  - 㯨  ।  */
	outportb(port+7,0xA0);
	/*  ⮢   3 ᥪ㭤 (  ) */
	if(WtBitMask(port+7,0x89,8,3))return(-1);
	/* 뢥 ⨪ */
	disable();
	for(i=0;i<6;i++) outport(port,*AP++);
	enable();

	/* 窠 室 横 ਥ  */
	GetNextBlk:
	/*    30 ᥪ㭤 */
	WtBitMask(port+7,0x80,0x00,30);
	/*  ਭ,   믮 -
		稬 ࠧ  ࠢ । */
	size=inportb(port+4) | (inportb(port+5)<<8);
	Last1X7=inportb(port+7);
	if(Last1X7&1)return(-1);	/* 訡 믮  */
	if(Last1X7&8){ /* 㦭 - 뫠 */
		if(inportb(port+2)&2){
		 /* CD */
				if(dir==1 && buffer != NULL ){
				/* ⥬ । */
				   while(size>0){
					int i=inport(port);
					size-=2;
					if(bufflen<1)break;
					*buffer++=i;
					readed+=2;
					bufflen-=2;
				   }
				}
				/* ய⨬ 㦭 ⮪ */
				while((size-=2)>0){inport(port);}
		}
		else{
		/*  CD */
			if(dir==0 && buffer!=NULL ){
				   while(bufflen>0 && size > 0){
					if(bufflen<1)break;
					outport(port,*buffer++);
					bufflen-=2;
					readed+=2;
					size-=2;
				   }
			}
			/* ᨬ ⮪ ﬨ */
			while((size-=2)>0){outport(port,0);}
		}
		goto GetNextBlk;
	}
	/* 뫠   㦭 -  襭 */
	Last1X7=inportb(port+7);
	if(Last1X7&1){
		/* 뫨 訡 */
		return(-1);
	}
return(readed);
}
