bass_fm macro()

    ld c, ixh       ;  8 /  8
    ld a, (bc)      ;  7 / 15
    ld e, a         ;  4 / 19
    ld a, (de)      ;  7 / 26
    ld (hl), a      ;  7 / 33
    inc l           ;  4 / 37
    ld (hl), a      ;  7 / 44
    inc l           ;  4 / 48
    add ix, sp      ; 15 / 63

mend

bass_unison macro(count)

    if ((count & 1) = 0)

        ld e, h     ;  4 /  4
        ld a, (de)  ;  7 / 11
        ld e, l     ;  4 / 15
        add hl, sp  ; 11 / 26
        ex de, hl   ;  4 / 30
        add a, (hl) ;  7 / 37
        rra         ;  4 / 41
        ld (bc), a  ;  7 / 48
        inc c       ;  4 / 52
        ld (bc), a  ;  7 / 59
        inc c       ;  4 / 63

    else

        ld l, d     ;  4 /  4
        ld a, (hl)  ;  7 / 11
        ld l, e     ;  4 / 15
        add a, (hl) ;  7 / 22
        rra         ;  4 / 26
        ld (bc), a  ;  7 / 33
        inc c       ;  4 / 37
        ld (bc), a  ;  7 / 44
        inc c       ;  4 / 48
        ex de, hl   ;  4 / 52
        add hl, sp  ; 11 / 63

    endif

mend

main_fm macro()

    ld c, ixh       ;  8 /  8
    ld a, (bc)      ;  7 / 15
    ld e, a         ;  4 / 19
    ld a, (de)      ;  7 / 26
    add a, (hl)     ;  7 / 33
    nop             ;  4 / 37
    ld (hl), a      ;  7 / 44
    inc l           ;  4 / 48
    add ix, sp      ; 15 / 63

mend

main_osc_sync macro(count)

    add ix, sp      ; 15 / 15
    sbc a, a        ;  4 / 19
    and e           ;  4 / 23
    add a, b        ;  4 / 27
    ld e, a         ;  4 / 31
    ld a, (de)      ;  7 / 38
    add a, (hl)     ;  7 / 45
    nop             ;  4 / 49
    ld (hl), a      ;  7 / 56
    inc l           ;  4 / 60

    if ((count % 3) = 2)

        ld a, r     ;  3 / 63

    endif

mend

; ============================================

fill_empty_sample   macro(buffer_size, start, steps, divisor)
    if ($ % buffer_size != 0)

        empty_sample((buffer_size), (start), (steps), (divisor))

    endif

mend

empty_sample        macro(buffer_size, start, steps, divisor)

    db start / divisor
    offset = steps

    next_pos = $ + buffer_size
    until_pos = next_pos - (next_pos mod buffer_size)
    loop_counter = until_pos - $


    loop loop_counter
        db (LOW (start + offset)) / divisor
        offset = offset + steps

    lend

mend

; ============================================

current_tab_label = ""
current_align_val = 0
current_start_pos = 0

; declares a table that must not span a 256-byte
; page boundary.
;
; Since the assembler won't let us decide beforehand
; whether a table should be aligned, we have to do
; things the cheap 'n nasty way.
BEGIN_PAGE_TABLE    macro(tab_label, align_val)

    if (::current_tab_label <> "")
        zeuserror "Trying to declare table \"", tab_label, "\"when the declaration of table \"", ::current_tab_label, "\" is still in progress!"
    endif

    ::current_tab_label = tab_label
    ::current_align_val = align_val
    ::current_start_pos = $

    if (align_val)
        align 256
    endif

    ::LABEL(tab_label)

mend

END_PAGE_TABLE      macro(tab_label)

    if (::current_tab_label = "")
        zeuserror "Trying to end declaration of table \"", tab_label, "\" which has not started!"
    endif

    ::LABEL(tab_label + "_end")

    tab_start = LABEL(tab_label)
    tab_end = LABEL(tab_label + "_end")
    tab_size = tab_end - tab_start

    tab_unaligned_start = current_start_pos
    tab_unaligned_end = current_start_pos + tab_size

    if ((tab_unaligned_start <> tab_unaligned_end) and ((HIGH tab_unaligned_start) <> (HIGH (tab_unaligned_end - 1))))
        if (not current_align_val)
            zeuserror tab_label, " should be aligned!"
        endif
    else
        if (current_align_val)
            zeuserror tab_label, " should not be aligned!"
        endif
    endif

    ::current_tab_label = ""

mend

; ============================================

current_sample = ""
current_sample_addr = 0

BEGIN_SAMPLE        macro(sample_label)

    if (::current_sample <> "")
        zeuserror "Trying to declare sample \"", sample_label, "\"when the declaration of sample \"", ::current_sample, "\" is still in progress!"
    endif

    ::current_sample = sample_label
    ::current_sample_addr = $

    ::LABEL(sample_label)

mend

END_SAMPLE          macro(sample_label)

    if (::current_sample = "")
        zeuserror "Trying to end declaration of sample \"", sample_label, "\" which has not started!"
    endif

    while ((($ - current_sample_addr) % 60) <> 0)
        db $80
    wend

    ::LABEL(sample_label + "_end")

    ::LABEL(sample_label + "_length", (::LABEL(sample_label + "_end") - ::LABEL(sample_label)) / 60)

    ::current_sample = ""

mend

; ============================================

; plants four bytes as lookup entries for the
; waveform drawing function.
GenVolumeEntry      macro (index)

    ; scale to 0-15 (this should probably be improved)
    volume = abs(index - $20)

    left_word = $0001
    right_word = $8000

    loop volume
        left_word   = (left_word << 1)  | $0001
        right_word  = (right_word >> 1) | $8000
    lend

    ; output a single byte at a time
    ; because they should be big-endian
    db (left_word >> 8) & $ff
    db (left_word) & $ff

    db (right_word >> 8) & $ff
    db (right_word) & $ff

mend

; ============================================
