ROM_load equ $0562      ; LD-BYTES, but some setup code is skipped.
sp_temp  equ $4880      ; in display file

loader_0 equ $4893      ; hide loader in the loading screen at (19,12)
loader_1 equ $4993      ; in 12x6 area
loader_2 equ $4A93
loader_3 equ $4B93
loader_4 equ $4C93
loader_5 equ $4D93
loader_6 equ $4E93
loader_7 equ $4F93

import_bin "loading_screen.scr", $4000

; max 12 bytes per segment
org loader_0

    di                                  ; 1 /  1

    ; in display file somewhere
    ld sp, sp_temp                      ; 3 /  4

    ; paging port
    ld bc, $7ffd                        ; 3 /  7
    ld a, $50                           ; 2 /  9

    jp loader_1                         ; 3 / 12

org loader_1

    ; page in required RAM bank
    out (c), a                          ; 2 /  2

    ; address and length of data to load
    ld ix, bank_start_0                 ; 4 /  6
    ld de, bank_size_0                  ; 3 /  9

    jp loader_2                         ; 3 / 12

org loader_2

    ; load data block and set carry for loading (not verify)
    scf                                 ; 1 /  1
    sbc a, a                            ; 1 /  2
    ex af, af'                          ; 1 /  3

    call ROM_load                       ; 3 /  6

    ld de, bank_size_2                  ; 3 /  9

    jp loader_3                         ; 3 / 12

org loader_3

    ld ix, bank_start_2                 ; 4 /  4

    scf                                 ; 1 /  5
    sbc a, a                            ; 1 /  6
    ex af, af'                          ; 1 /  7

    jp loader_4                         ; 3 / 10

org loader_4

    call ROM_load                       ; 3 /  3

    ld ix, bank_start_5 + $1b00         ; 4 /  7

    jp loader_5                         ; 3 / 10

org loader_5

    ld de, bank_size_5 - $1b00          ; 3 /  3

    scf                                 ; 1 /  4
    sbc a, a                            ; 1 /  5
    ex af, af'                          ; 1 /  6

    call ROM_load                       ; 3 /  9

if 0
    jp tracker_main                     ; 3 / 12
else
    jp setup                            ; 3 / 12
endif
