#!/usr/bin/env bash

# this is just the normal build script but with unnecessary stuff removed.

ZEUS_DIR="tools/zeus"
BUILD_DIR="bin/build"
INTERMEDIATE_DIR="${BUILD_DIR}/ir"

git_version=$(git describe --long --tags --dirty --always)
build_name_128="synth-${git_version}_128"

if ! [ -d "$BUILD_DIR" ]; then
    mkdir -p "$BUILD_DIR"
fi

if [ -d "$INTERMEDIATE_DIR" ]; then
    rm -r -- "$INTERMEDIATE_DIR"
fi
mkdir "$INTERMEDIATE_DIR"

mkdir "$INTERMEDIATE_DIR/128"

echo Building $build_name_128...

if [ "$1" != "--no-wine" ]; then
    USE_WINE='wine'
fi

echo
(cd src && exec ${USE_WINE} ../${ZEUS_DIR}/zcl.exe synth_128.asm)

${USE_WINE} ./tools/bas2tap/bas2tap.exe -a10 "-ssynth" src/loader.bas ${INTERMEDIATE_DIR}/loader.tap

if ! [ -f "${INTERMEDIATE_DIR}/loader.tap" ]; then
    echo -e '\nERROR building synth!'
    exit 1
fi

${USE_WINE} ./tools/GenTape/GenTape.exe ${INTERMEDIATE_DIR}/synth_128.tap \
    hdata \'screen\' 4000 ${INTERMEDIATE_DIR}/128/loadscr.bin \
    data ${INTERMEDIATE_DIR}/128/bank0.bin \
    data ${INTERMEDIATE_DIR}/128/bank2.bin \
    data ${INTERMEDIATE_DIR}/128/bank5.bin

cat ${INTERMEDIATE_DIR}/loader.tap ${INTERMEDIATE_DIR}/synth_128.tap > ${BUILD_DIR}/${build_name_128}.tap

echo -e 'synth build successful.'
