#!/usr/bin/env bash

ZEUS_DIR="tools/zeus"
BUILD_DIR="bin/build"
INTERMEDIATE_DIR="${BUILD_DIR}/ir"

git_version=$(git describe --long --tags --dirty --always)
build_name_128="synth-${git_version}_128"
build_name_specdrum="synth-${git_version}_specdrum"

if ! [ -d "$BUILD_DIR" ]; then
    mkdir -p "$BUILD_DIR"
fi

if [ -d "$INTERMEDIATE_DIR" ]; then
    rm -r -- "$INTERMEDIATE_DIR"
fi
mkdir "$INTERMEDIATE_DIR"

mkdir "$INTERMEDIATE_DIR/128"
mkdir "$INTERMEDIATE_DIR/specdrum"

echo Building $build_name_128...

if [ "$1" != "--no-wine" ]; then
    USE_WINE='wine'
fi

echo
(cd src && exec ${USE_WINE} ../${ZEUS_DIR}/zcl.exe synth_128.asm)
echo
(cd src && exec ${USE_WINE} ../${ZEUS_DIR}/zcl.exe synth_specdrum.asm)

${USE_WINE} ./tools/bas2tap/bas2tap.exe -a10 "-ssynth" src/loader.bas ${INTERMEDIATE_DIR}/loader.tap

if ! [ -f "${INTERMEDIATE_DIR}/loader.tap" ]; then
    echo -e '\nERROR building synth!'
    exit 1
fi

${USE_WINE} ./tools/GenTape/GenTape.exe ${INTERMEDIATE_DIR}/synth_128.tap \
    hdata \'screen\' 4000 ${INTERMEDIATE_DIR}/128/loadscr.bin \
    data ${INTERMEDIATE_DIR}/128/bank0.bin \
    data ${INTERMEDIATE_DIR}/128/bank2.bin \
    data ${INTERMEDIATE_DIR}/128/bank5.bin

${USE_WINE} ./tools/GenTape/GenTape.exe ${INTERMEDIATE_DIR}/synth_specdrum.tap \
    hdata \'screen\' 4000 ${INTERMEDIATE_DIR}/specdrum/loadscr.bin \
    data ${INTERMEDIATE_DIR}/specdrum/bank0.bin \
    data ${INTERMEDIATE_DIR}/specdrum/bank2.bin \
    data ${INTERMEDIATE_DIR}/specdrum/bank5.bin

cat ${INTERMEDIATE_DIR}/loader.tap ${INTERMEDIATE_DIR}/synth_128.tap > ${BUILD_DIR}/${build_name_128}.tap
cat ${INTERMEDIATE_DIR}/loader.tap ${INTERMEDIATE_DIR}/synth_specdrum.tap > ${BUILD_DIR}/${build_name_specdrum}.tap

echo -e 'synth build successful.'
