
rseg CODE

IM1_STACK_FRAME_SYS EQU 04300h
IM1_STACK_FRAME_APP EQU 04200h
TEMP_BUFFER_SECTOR	EQU 04000h

//---------------------------------------------------------------------
//
// RST0 - swap 
//

        im 1     // 2
        jp start // 3
make_user_im1:
        jp (hl)  // 1

user_im1_routine:
        defw 0     // 2

//---------------------------------------------------------------------
//
// RST8 -    (0-15)
//
//    
//
//  : AF
//
rst8_handler:
        bit 3, a
        jp nz, set_bord_with_bright
bord_port1:
        out (7eh),a
        ret

//---------------------------------------------------------------------
//
// RST16 -   (    IM1)
//
//    
//
//  0 - 320x200x16
//  1 - 640x200
//  2 - ???
//  3 - Sinclair
//
//   : AF
//
rst16_handler:
        jp change_video_mode_ATM1
        
current_border_color:
        defb 0
        defb 0, 0, 0, 0

//---------------------------------------------------------------------
//
// RST24 -   (    IM1)
//
//  HL -   (16 )   .
//          IM1    
//
//  : --
//
rst24_handler:
        ld (palette_table_addr+1), hl
        ret
        defb 0, 0, 0, 0

//---------------------------------------------------------------------
//
// RST32 -      
//
// :
//  D5, D4, D2, D1, D0
//  D3 -   
//  D6 -     
//  D7 -    
//
//  : AF, BC, DE
//
rst32_handler:
        jp switch_mem_bank_ATM1
current_mem_bank:
        defb 0
        defb 0, 0, 0, 0

//---------------------------------------------------------------------
//
// RST40 -       
//
//  : AF, BC, E
// 
rst40_handler:
        ld a, (current_mem_bank)
        jp make_mem_switch_ATM1
        defb 0, 0

//---------------------------------------------------------------------

rst48_handler:
		ld b, 16
		jp convert_palette_ATM1_to_ATM2
        defb 0, 0, 0

// ---------------------------------------------------------------------

rst56_handler:
        di
        ld (orig_stack+1), sp
        ld sp, IM1_STACK_FRAME_SYS
        push af
        push de
        push hl
        push bc                
        push ix
        push iy
        ex af,af'
        exx
        push af
        push de
        push hl
        push bc

        call sys_im1
        ld hl, (user_im1_routine)
        ld a, l
        or h
        call nz, make_user_im1

        rst 40
        pop bc
        pop hl
        pop de
        pop af
        ex af, af'
        exx
        pop iy
        pop ix
        pop bc
        pop hl
        
		ld a, (orig_stack+2)
        cp RASTER_SCANLINE_BUFFER
        jr z, restore_corrupted_stack_data
		
		pop de        
        pop af
orig_stack
		ld sp, 0        
        ei        
        ret
        
restore_corrupted_stack_data:
        ld de, (orig_stack+1) // DE    , 
							  // ..       									  
		//   
		ld a,(de)
		ld (corrupted_stack_return+1), a
		inc de
		ld a,(de)
		ld (corrupted_stack_return+2), a
				
		//   
		ld a, h
		ld (de), a
		ld a, l
		dec de
		ld (de), a
				
		//       							  
        pop de
        pop af
		ei
		ld sp, (orig_stack+1)
		inc sp
		inc sp
corrupted_stack_return:
		jp 0        
        
//---------------------------------------------------------------------

       