

GFX_UNPACK_MULTTABLE_HIBYTE EQU 043h
GFX_UNPACK_LOOP_HIBYTE EQU 044h

//
// HL -  
// A -   

GfxUnpack:
	ld iyh, a
	ld a, (hl)
	ld c, a
	inc hl
	ld a, (hl)	
	or a
	ret z
	inc hl
	inc hl
	inc hl
	ld b, a
		
	exx
	ld bc, 40
	exx
	ld ixh, GFX_UNPACK_LOOP_HIBYTE
	
GfxUnpack_ScrAddrPrepare:
	ld a, c
	exx
	ld l, a
	ld a, iyh
	ld h, a
	
GfxUnpack_InRowLoop:
	exx	
	ld a,(hl)
	inc hl
	inc a
	jr z, GfxUnpack_NextRow
	jp m, GfxUnpack_SkipLines
	add a,a
	cpl
	dec a
	ld ixl, a
	ld a, (hl)
	inc hl
	exx
	jp (ix)

GfxUnpack_NextRow:
	inc c
	djnz GfxUnpack_ScrAddrPrepare
	ret
	
GfxUnpack_SkipLines:
	exx
	ex de, hl
	ld h, GFX_UNPACK_MULTTABLE_HIBYTE
	ld l, a
	ld a, (hl)
	res 7, l
	ld h, (hl)
	ld l, a
	add hl, de
	jp GfxUnpack_InRowLoop
	
GfxUnpack_GenTables:
	//
	// 1)   
	//
	ld hl, GFX_UNPACK_LOOP_HIBYTE * 0100h
	ld b, 127
	
GfxUnpack_GenTables_Loop1:
	ld (hl), 077h // ld (hl),a opcode
	inc hl
	ld (hl), 009h // add hl,bc opcode
	inc hl
	djnz GfxUnpack_GenTables_Loop1
	ld (hl), 0C3h // jp NN opcode
	inc hl
	ld de, GfxUnpack_InRowLoop
	ld (hl), e
	inc hl
	ld (hl), d
	
	//
	// 2)  Y 
	//
	ld ix, GFX_UNPACK_MULTTABLE_HIBYTE * 100h + 80h
	ld hl, 0
	ld de, 40
	ld b, 080h 

GfxUnpack_GenTables_Loop2:	
	ld (ix+0), l
	ld (ix-080h), h
	inc ix
	add hl, de
	djnz GfxUnpack_GenTables_Loop2
	ret
	