#pragma once

#include "VideoModeBase.h"

// ---------------------------------------------------------------------- //

class CVideoModeAtm320x200 : public CVideoModeBase
{
    std::vector<BYTE> m_vecPixels;
    BYTE GetByte(int iBitplaneNum, int iX, int iY) const;
    void CompressBitplane(int iBitplaneNum, std::vector<BYTE>& vecCompressed);
    void CompressBitplaneChanges(int iBitplaneNum, CVideoModeAtm320x200& PrevFrame, std::vector<BYTE>& vecCompressed);
    void LookupCompressArea(int iBitplaneNum, int& iXMin, int& iXMax);

    void SetByte(int iBitplaneNum, int iX, int iY, BYTE pix);
    int UncompressBitplane(int iBitplaneNum, PBYTE pb);
    void DrawBitmap(int iID);

public:
    CVideoModeAtm320x200(CAtmPalette& plt, int iScaleFactor);

    CVideoModeAtm320x200(const CVideoModeAtm320x200& rhs) : CVideoModeBase(rhs.m_plt, 1)
    {
        *this = rhs;
    }
    CVideoModeAtm320x200& operator=(const CVideoModeAtm320x200& rhs)
    {
        m_vecPixels = rhs.m_vecPixels;
        return *this;
    }


    virtual bool Initialize() override;
    virtual int GetXDimension() const override {
        return 320;
    }
    virtual int GetYDimension() const override {
        return 200;
    }
    virtual BYTE GetPixel(int iX, int iY) const override;
    virtual void SetPixel(int iX, int iY, BYTE clr) override;
    virtual BYTE GetAttribute(int iX, int iY) const override
    {
        ASSERT( FALSE );
        return 0;
    }
    virtual void SetAttribute(int iX, int iY, BYTE clrAttr) override
    {
        ASSERT( FALSE );
    }
    void CompressFrame(std::vector<BYTE>& vecCompressed);
    void CompressChanges(CVideoModeAtm320x200& PrevFrame, std::vector<BYTE>& vecCompressed);
    int UncompressFrame(PBYTE pb);
};
typedef intrusive_ptr<CVideoModeAtm320x200> CVideoModeAtm320x200Ptr;



