;**************************************
;           DL_PerlinNoise
;         (c) DRAGONS' LORD
;**************************************
;       08.07.2024 - 10.07.2024
;**************************************

        device zxspectrum128
        
WinSizeX=32 ;размер
WinSizeY=24 ;окна генерации

        org     24576   ;#6000
begin
                ;ld      a,0
                ;out     (#fe),a
                ;ld      hl,16384+6144
                ;ld      de,16385+6144
                ;ld      bc,767
                ;ld      a,%00000111
                ;ld      (hl),a
                ;ldir

                ;LD HL, #0000
                ;LD (Camera.X.High), HL
                ;LD (Camera.X.Low), HL
                ;LD (Camera.Y.High), HL
                ;LD (Camera.Y.Low), HL
                
main            LD HL, #E000 ;57344 - размер буфера:8192 (128x64 max)
               
                ld c,WinSizeY ;Y   24..1
metCicleY       ld b,WinSizeX ;X   32..1
metCicleX       push bc
               ;отрисовщик тайлов перлина в буфер ---
               push hl
                exx
                LD HL, (Camera.X.High)                
                LD DE, 0
                exx
                LD HL, (Camera.X.Low)
                ld a,WinSizeX+1 : sub b
                ld d,0 : ld e,a ;X   32..1
                call Add32_32                  
                LD (Noise2D.Location.X.High), HL ;Noise2D + FNoise2D.Location.X.High
                LD (Noise2D.Location.X.Low), DE ;Noise2D + FNoise2D.Location.X.Low
                
                exx
                LD HL, (Camera.Y.High)                
                LD DE, 0
                exx
                LD HL, (Camera.Y.Low)
                ld a,WinSizeY+1 : sub c
                ld d,0 : ld e,a ;Y   24..1
                call Add32_32                  
                LD (Noise2D.Location.Y.High), HL ;Noise2D + FNoise2D.Location.Y.High
                LD (Noise2D.Location.Y.Low), DE ;Noise2D + FNoise2D.Location.Y.Low
                
                CALL PerlinNoise2D
                LD A, L                    ; в акуме значение шума -128 .. + 127
                add a,128 ;если хотим положительное
                srl a ;/2
                srl a ;/4
                srl a ;/8
                srl a ;/16 = 16 цветов
                ; фильтр-интерпритатор
                ;CP #10
                ;JR C, $+8
                ;AND %10100101
                ;RRCA
                ;XOR %10100101
                ;RLCA
                ;XOR %00101000
               pop hl
                LD (HL), A
               inc hl
               ;--------------------------------- ---       
                pop bc
                djnz metCicleX         
                ld a,c
                dec a
                ld c,a
                jr nz,metCicleY

                call printBuf
                ;di : halt
                call changeXY   
                jp main

changeXY        ld hl, Camera.X ;Camera + FLocation.X.Low
                call Inc32              
                ;call Dec32
                ld hl, Camera.Y ;Camera + FLocation.Y.Low  
                call Inc32               
                ;call Dec32              
                ret


                include "perlin_noise.asm"

                align 128
FONTCHANK       incbin "FONTCHANK2.SpecCHR",0,128 ;используются только первые 16х8=128 байт из 768                  
                
;c2p_32x24
;230510t - 3.2 фрэйма
;перекинет видеобуфер на экран в виде чанков 32х24 16color                
printBuf        ld      ix,#E000 ;57344 - videobuf
                ld      c,8                
                ld      hl,#4000
                call    printLoop1
                ld      c,8
                ld      hl,#4800
                call    printLoop1
                ld      c,8
                ld      hl,#5000
                call    printLoop1
                ret                
printLoop1      ld      b,32
printLoop2      ld      de,FONTCHANK            ;фонт с чанками CHNF
                ld      a,(ix)
                inc     ix                
                sla     a                       ;*2
                sla     a                       ;*4
                sla     a                       ;*8
                add     a,e
                ld      e,a  
               dup 7
                ld      a,(de)
                ld      (hl),a
                inc     de
                inc     h
               edup
                ld      a,(de)
                ld      (hl),a
                ld      de,#0700
                or      a
                sbc     hl,de
                inc     l
                djnz    printLoop2                                
                ld      a,c
                dec     a ;тут установится флаг нуля
                ld      c,a
                jr      nz,printLoop1                
                ret
                
                 
                
                
endall
        display "CODE:          ",/D,begin,"..",/D,endall," size ",/D,endall-begin

        ;savebin "PG18.C",24576,49152-24576   ;5+2 size 24576
        ;page 0
        ;savebin "PG16.C",49152,16384         ;0
        ;page 1
        ;savebin "PG17.C",49152,16384         ;1
        ;page 3
        ;savebin "PG19.C",49152,16384         ;3
        ;page 4
        ;savebin "PG20.C",49152,16384         ;4
        ;page 6
        ;savebin "PG22.C",49152,16384         ;6
        page 7
        ;savebin "PG23.C",49152,16384         ;7

        savesna "DL_PerlinNoise.sna",begin

        LABELSLIST "..\..\..\_EMULATORS\unreal\unreal\user.l"