;=================== INIT PART ========================

mkc2p
	;call mktcol ;l=color,h=light to light+hue LC1=%11ccLLL1, hue %11RGCld0
	;call mktatr ;twohues12,twohues34=%11RGCld0 11RGCld0 to attr and attrcode=%1aaa1111
	;call mktch ;twochunks %11ccLLL1 (left,B) 1aaaLLL1 (right,C) to gfx
	;ret
	
;l=color,h=light to light+hue LC1=%11ccLLL1, hue %11RGCld0
;%11LLLLL0 10CCCCC0 (+inc)
;CCCCC=
;00lll - W
;01lll - R
;10lll - C
;11lll - G
;LLLLL*lll=
;   0 => 000 + d => 0%
;   1 => 001 + d => 50% 
;   2 => 010 + d => 87.5%
;   3 => 010 C1C2=> 12.5%
;   4 => 011 C1C2=> 25%
;   5 => 100 C1C2=> 50%
;   6 => 101 C1C2=> 75%
;   7 => 101 + l => 12.5%
;   8 => 110 + l => 50% 
;   9 => 111 + l => 100%
;cc=
;00 - W
;01 - R
;10 - C/G
;11 - C1-C2 (don't mind the hue)
;l means lighter 1/3 range of light is used
;d means dark 1/3 range of light is used
;if hues are different (except for exactly one "incompatible" hue with double upper or double dark range), then 0-W
;if lighter and dark range are both marked, then 0-W
;if lighter range is marked, then C2-W
;if dark range is marked, then 0-C1
;if no ranges are marked, then C1-C2 (with C1-C2 marked in cc too)
mktcol
	ld d,%11000000 ;tcolor/256
mktcol0:
	ld e,%10000000 ;tcolor
mktcol1:

;lll=f(e)
	ld a,e
	rra
	and %111
	ld b,a
	jr z,mktcolz ;a=0 => light=0

;LLLLL=f(d)
	ld a,d
	rra
	and %11111
	ld c,a

	if GRASS
	cp %11111
	jr z,mktcolzmax ;white is always white
	endif

;count light=LLLLL*lll
	xor a
	add a,c
	djnz $-1
mktcolz
	rra
	rra
	rra
	rra
mktcolzmax
	and %1111
	sub 2
	jr nc,$+3
	xor a
	cp 9
	jr c,$+3
	ld a,9
;a=light=0..9

;count C1C2,l,d
;count l
	ld bc,%11000010
	cp 7
	jr c,$+2+2+1+1
	set 2,c ;set l
	dec a
	dec b ;res C1C2

;count d
	cp 3
	jr c,$+2+2+1+1
	res 1,c ;res d
	dec a
	inc b ;set C1C2
;a=LLL=0..7
;b=C1C2 (0 for dark, 1 for mid, 0 for light)
;c=%11000ld0

;count LLL (light used)
	add a,a
	or b
	or %11000000
	ld b,a ;%1100LLLc (c=C1C2)

;count b=%11ccLLL1 (C1C2 used for counting cc)
	ld a,e
	and %00110000 ;cc (00=W, 01=R, 10=C, 11=G(temporary))
	jr z,mktcolw ;W, so don't mind C1C2 flag
	cp %00110000 ;G?
	jr nz,$+4
	ld a,%00100000 ;C/G
	bit 0,b
	jr z,$+4
	ld a,%00110000 ;C1-C2
mktcolw
	inc a ;%00cc0001
	or b
	;ld b,a ;%11ccLLL1

	;ld a,b ;%11ccLLL1
	ld (de),a
	inc e

;c=%11000ld0
;count c=%11RGCld0
	ld a,e
	and %00110000 ;cc (00=W, 01=R, 10=C, 11=G(temporary))
	jr z,mktcolRGC ;W,z
	cp %00100000 ;C
	jr nz,mktcolnC
	set 3,c ;C
	jr mktcolCq
mktcolnC
	jr c,mktcolR
;G,nz
mktcolRGC
	set 4,c ;G
	jr nz,mktcolCq
	set 3,c ;C
mktcolR
	set 5,c ;R
mktcolCq

	ld a,c ;%11RGCld0
	ld (de),a
	inc e
	bit 6,e ;%10CCCCC0
	jr z,mktcol1
	inc d
	inc d
	jr nz,mktcol0
	;ret


;twohues12,twohues34=%11RGCld0 11RGCld0 to attr and attrcode=%1aaa1111
;aaa=
;000 - W (W1|W2==1 or l1|l2==1,d1|d2==1 or (RGC1!=RGC2 and not (l1==l2 and exactly one of hues is "incompatible")))
;001 - R (none of above, R1|R2==1)
;010 - C/G (none of above, G1|G2==1)
;[011 - temporary G for C2-W]
 ;or (for R, C/G, not for W)
;100 - 0-C1 (d1|d2==1,l1|l2==0)
;000 - C2-W (l1|l2==1,d1|d2==0)
;111 - C1-C2 (l1|l2==0,d1|d2==0,RGCld1==RGCld2) (chunk should contain cc=11)
mktatr:
	ld h,tattr/256 ;%11000000
mktatr0:
	ld l,tattr&255 ;%11000000
mktatr1:

;make b=%1gRGCldi (g=G|C,i=incompatible)
	ld b,h
	res 6,b
	ld a,h
	and %00011000 ;GC
	jr z,mktatrbq
	set 6,b ;g
	ld a,h
	cpl
	and %00111000 ;RGC
	jr z,mktatrbq ;W
	bit 5,h ;R
	jr z,mktatrbq ;no R
	inc b ;R+C/G, mark i
mktatrbq

;make c=%1gRGCldi (g=G|C,i=incompatible)
	ld c,l
	res 6,c
	ld a,l
	and %00011000 ;GC
	jr z,mktatrcq
	set 6,c ;g
	ld a,l
	cpl
	and %00111000 ;RGC
	jr z,mktatrcq ;W
	bit 5,l ;R
	jr z,mktatrcq ;no R
	inc c ;R+C/G, mark i
mktatrcq

	ld a,b
	xor c ;compare hues
	ld d,a

;find c=aaa=%000..111

;1.find c=hue
	ld a,b
	or c
	cpl
	and %00000110 ;ld
	jr z,mktatrhuew ;incompatible light ranges (l==d==1), get W
	;ld a,b
	;xor c
	ld a,d ;hues XORed
	and %01100000 ;Rg
	jr z,mktatrhueget1 ;Rg1==Rg2, get hue1
;Rg1!=Rg2
;there can be 0-C1 if both dark and exactly one of hues is "incompatible" (don't mistake for 0-W)
;there can be C2-W if both light and exactly one of hues is "incompatible" (don't mistake for 0-W)
	ld a,b
	or c
	and %00000110 ;ld
	jr z,mktatrhuew ;no light ranges marked
	;ld a,b
	;xor c
	ld a,d ;hues XORed
	and %00000110 ;ld
	jr nz,mktatrhuew ;different light ranges
	bit 0,b ;i
	ld a,c
	jr nz,mktatrhueget ;hue1 is "incompatible", get hue2 (if both incompatible, there will be W)
	rra ;i
	jr nc,mktatrhuew ;hue1 is "compatible", hue2 is "compatible" but they differ, get W
;hue2 is "incompatible", get hue1
mktatrhueget1
	ld a,b ;get hue1
mktatrhueget
	rra ;i
	jr c,mktatrhuew ;incompatible
	cpl
	and %11100
	jr z,mktatrhuew ;W
	bit 4,a ;R (5-1)
	ld c,%001 ;hue=R
	jr z,mktatrhueq
	inc c ;%010 ;hue=C
	bit 2,a ;C (3-1)
	jr z,mktatrhueq
	inc c ;%011 ;hue=G (temporary)
	bit 3,a ;G (4-1)
	jr z,mktatrhueq
mktatrhuew
	ld c,%000 ;hue=W
mktatrhueq

;2.find e=light range
	ld a,h
	or l
	rra
	rra ;d flag
	jr nc,mktatrnd ;d==0
	rra ;l flag
	jr c,mktatrlw ;incompatible light ranges (l==d==1), so hue=W
	ld e,%100 ;dark
	jr mktatrlq
mktatrnd ;d==0
	rra ;l flag
	ld e,%000 ;light
	jr c,mktatrlq ;l==1
	ld e,%111 ;C1-C2
	ld a,d ;hues XORed
	and %11100111 ;skip G,C, leave G/C only
	jr z,mktatrlq ;C1-C2 ok
;incompatible colors in C1-C2
mktatrlw
	ld c,%000 ;hue=W because of incompatible colors
mktatrlq

;3.OR hue|lightrange
;if hue==000 (W) then lightrange=000 (for 0-W)
;if hue==011 (temporary G for C2-W) and lightrange!=000 then hue=010 (C/G)
	ld a,c ;hue
	or a
	jr z,mktatraaaq ;0-W
	cp %011 ;temporary G for C2-W
	jr nz,mktatraaaor
	bit 2,e
	jr z,mktatraaaor ;lightrange==000, so keep temporary G
	dec a ;%010 ;C/G
mktatraaaor
	or e
	ld c,a
mktatraaaq

;find attr
	ld b,c ;aaa
	ld (hl),#07+bright ;000 = 0-W
	djnz $+4
	ld (hl),#37+bright ;001 = Y-W
	djnz $+4
	ld (hl),#2f+bright ;010 = C/G-W
	djnz $+4
	if GRASS
	ld (hl),#37+bright ;011 = (Y-W)
	else
	ld (hl),#27+bright ;011 = G-W
	endif
	dec b
	djnz $+4
	ld (hl),#02+bright ;101 = 0-R
	djnz $+4
	if GRASS
	ld (hl),#04+bright ;110 = (0-G)
	else
	ld (hl),#01+bright ;110 = 0-B
	endif
	djnz mktatrnc1c2
;111 = C1-C2
	bit 5,h ;R
	;ld (hl),#16+bright ;R-Y
	ld (hl),#32+bright ;R-Y
	jr nz,mktatrnc1c2
	bit 4,h ;G
	;ld (hl),#0c+bright ;B-G
	if GRASS
	ld (hl),#34+bright ;(G-Y)
	else
	ld (hl),#21+bright ;B-G
	endif
	jr nz,mktatrnc1c2
	;inc (hl) ;#0d+bright ;B-C
	ld (hl),#29+bright ;B-C
mktatrnc1c2

	inc l

;find attrcode
	ld a,c
	cp %011 ;G
	jr nz,$+3
	dec a ;010 - C/G
	add a,a
	add a,a
	add a,a
	add a,a
	or %10001111
	ld (hl),a ;attrcode

	inc l
	jp nz,mktatr1
	inc h
	inc h
	jp nz,mktatr0
	;ret

;attr[attrcode]
;db #07+bright ;000 = 0-W
;db #37+bright ;001 = Y-W
;db #2f+bright ;010 = C/G-W - check big0=G
;db #27+bright ;011 = IMPOSSIBLE (temporary G-W)
;db #07+bright ;100 = 0-W
;db #02+bright ;101 = 0-R
;db #01+bright ;110 = 0-B
;db #02+bright ;111 = C1-C2 - hue from twohues (they are identical)



;twochunks %11ccLLL1 (left,B) 1aaaLLL1 (right,C) to gfx
;                    dark        mid        light
;0-C1 (101 R,110 C/G) *3          max       [max]
;C1-C2 (111)         [0]          *3        [max]
;C2-W (001 R,010 C/G)[0]          0          *3
;0-W (000)            +           +          +
;wrong 0-C1 (100)     0           0         [0]
mktch
	ld d,%11000000
mktch0:
	inc d
	ld e,%10000000
mktch1:
	ld b,d
	ld c,e

;right chunk wrong?
;check aaa=100 (wrong 0-C1)
	ld a,c ;right chunk
	and %01110000 ;aaa
	cp %01000000 ;aaa=100 (wrong 0-C1)
	jr nz,mktchrok
;right chunk wrong!
	ld c,%11000001 ;make it black
mktchlok

;left chunk wrong?
;if aaa!=x11 (C1-C2), don't mind the hue
	ld a,c ;right chunk
	cpl
	and %00110000 ;xaa
	jr z,mktchrok
;compare hue in cc with hue in aaa (x00=W, x01=R, x10=C/G)
	cpl ;ld a,c
	xor b
	and %00110000 ;aa xor cc
	jr z,mktchrok
;left chunk wrong!
;if 0-W, keep the light
	ld a,c
	and %01110000 ;aaa ;zero means 0-W
	jr z,mktchrok
;if C2-W, make it white
;else (0-C1) make it black
	and %01000000 ;a00 ;zero means C2-W
	ld b,%11001111 ;white
	jr z,mktchrok
	ld b,%11000001 ;black
mktchrok

;correct the light according to the table
;                 dark(000..010)  mid   light(101..111)
;C1-C2 (111)      IMPOSSIBLE      *3       IMPOSSIBLE
;0-W (000)            +           +          +
;0-C1 (1xx)           *3          max      IMPOSSIBLE
;C2-W (0xx)         IMPOSSIBLE    0          *3
	ld a,c
	and %01110000 ;aaa
	ld hl,tchwhite
	jr z,mktchok ;0-W
	cp %01110000
	ld hl,tchmid
	jr z,mktchok ;C1-C2
	and %01000000 ;a00 ;zero means C2-W
	ld hl,tchlight
	jr z,mktchok
	ld hl,tchdark ;0-C1
;make sure there isn't a "C1-C2" chunk with 0-C1 table
	;ld a,b
	;cpl
	;and %00110000 ;C1-C2
	;jr nz,mktchok
;"C1-C2" chunk with 0-C1 table
;correct the chunk to maximize the pattern
	;ld b,%11111111
mktchok
	ld a,c ;right chunk
	rra
	and 7
	ld c,a
	ld a,b
	ld b,0
	push hl
	add hl,bc
	ld c,(hl)
	pop hl
	push bc
	rra
	and 7
	ld c,a
	add hl,bc
	pop bc
	ld b,(hl)
;b,c=pattern index for left,right chunk

;get right chunk pattern (b,c)
	ld hl,tchpattern
	ld a,b
	ld b,0
	add hl,bc
	ld b,(hl)
	inc hl
	ld c,(hl)

;get left chunk pattern (h,l)
	push bc
	ld hl,tchpattern
	ld c,a
	ld b,0
	add hl,bc
	ld a,(hl)
	inc hl
	ld l,(hl)
	pop bc
	;ld h,a

	;ld a,h
	xor b
	and #f0
	xor b
	ld (de),a
	inc e
	ld a,l
	xor c
	and #f0
	xor c
	ld (de),a

	inc e
	jp nz,mktch1
	inc d
	jp nz,mktch0
	ret

_=2
tchdark ;for 000..010 and nodark
	if GRASS
	db 3*_,5*_,7*_,8*_,8*_,8*_,8*_,8*_
	else
	db 0*_,4*_,7*_,8*_,8*_,8*_,8*_,8*_
	endif
tchmid ;for 010..101
	;db 1*_,1*_,1*_,2*_,4*_,6*_,6*_,6*_
	db 6*_,6*_,6*_,4*_,2*_,1*_,1*_,1*_
tchlight ;for nolight and 101..111
	if GRASS
	db 0*_,0*_,0*_,0*_,0*_,1*_,3*_,6*_
	else
	db 0*_,0*_,0*_,0*_,0*_,1*_,4*_,8*_
	endif
tchwhite ;for 000..111
	if GRASS
	db 2*_,3*_,4*_,5*_,6*_,6*_,7*_,8*_
	else
	db 0*_,1*_,2*_,3*_,4*_,5*_,6*_,8*_
	endif

tchpattern
;2406
;5173
	dw #0000
	dw #2200
	dw #2244 ;#aa00
	dw #aa44 ;#aa44
	dw #aa55 ;#aa55
	dw #ee55 ;#ee55
	dw #eedd ;#ff55
	dw #ffdd ;#ffdd
	dw #ffff
