; mempages
gfxBank=0
scrBank0=1
scrBank1=3
mapBank0=4
mapBank1=6
muzBank=7

; graphic layouts
bgLay=1			; bg
walLay=2		; inpassable
itmLay=3		; items
npcLay=4		; NPC
plrLay=5		; Hero
topLay=6		; top tiles
infLay=7		; tables

; direction
dirNorth=0	; up
dirUp=dirNorth
dirEast=1	; right
dirRight=dirEast
dirSouth=2	; down
dirDown=dirSouth
dirWest=3	; left
dirLeft=dirWest

; eqiuipment places
eArmor	equ 0
eSword	equ 1
eShield	equ 2
eAmulet	equ 3
eMax	equ 4

; type of amulet / potion
fxNONE	equ 0	; no action
fxSTART	equ 1	; at start of battle
fxTURN	equ 2	; every turn
fxATK0	equ 3	; before attack
fxATK1	equ 4	; after ATK damage calc
fxDEF0	equ 5	; before deffence
fxDEF1	equ 6	; after DEF damage calc

; positions
posVIC	equ 0x80
posATK	equ 0x81
posMID	equ 0x82

; battle script id
bsIDL	equ 0	; idle
bsATK	equ 1	; attack
bsDEF	equ 2	; defence
bsWIN	equ 3	; win
bsDTH	equ 4	; lose
bsPOT	equ 5	; use potion
bsMAG	equ 6	; use magick
bsSHW	equ 100	; user : npc appears

; macros

	MACRO DBGSTOP
	ld a,2
	out (0xfe),a
	jr $
	ENDM

	MACRO DBW bt,wr
	db bt
	dw wr
	ENDM
	
	MACRO DBBW b1,b2,wr
	db b1,b2
	dw wr
	ENDM
	
	MACRO LDB dst,src
	ld a,src
	ld dst,a
	ENDM

	MACRO LDHL
	ld a,(hl)
	inc hl
	ld h,(hl)
	ld l,a
	ENDM
	
	MACRO ADDA hr,lr
	add a,lr
	ld lr,a
	adc a,hr
	sub lr
	ld hr,a
	ENDM
	
	MACRO SFXDATA note,smpadr,ornadr
	db note
	dw smpadr,ornadr
	ENDM

	MACRO ITEM id,map,x,y,sicon,bicon,nadr	; ID, mapID, X, Y, small.icon.tile.nr, big.icon.nr
	db id,map,x,y,sicon
	dw 36*bicon+itemBIG		; FIXME !
	db map,x,y			; for init
	db 1				; count
	dw nadr
	db 0				; flag: b0:in hands
	ENDM
itemDSCSize=14

	MACRO CHAR id,map,x,y,lay,sadr,aadr
	db id,map,x,y,lay
	dw sadr
	db 1
	dw aadr
	db 2	; direction
	db 0	; reserved
	db map,x,y
	dw sadr,aadr
	db 0,0
	db 0,0,0	; cycle
	ENDM
chaDSCSize=24
	
	MACRO ELEM id,map,x,y,lay,sadr,aadr,afadr
	db id,map,x,y,lay
	dw sadr
	db 1
	dw aadr
	dw afadr	; affect script addr (0:none)
	db map,x,y	; init block
	dw sadr,aadr
	dw afadr
	db 0,0,0	; cycle
	ENDM
actDSCSize=chaDSCSize

	MACRO DOOR id,map,x,y,dx,dy,map2,x2,y2,dir2,flag
	db id,(flag & 1) | ((flag & 1)<<1),map,x,y,dx,dy	; door position & size
	db map2,x2,y2,dir2					; where hero moved to
	ENDM
doorDSCSize=11
	
	MACRO ZONE id,map,x,y,dx,dy,adr,flag
	db id,(flag & 1) | ((flag & 1)<<1),map,x,y,dx,dy
	dw adr
	ENDM
zoneDSCSize=9
	
	MACRO FIGHTER id,x,y,adr,flag
	db id,x,y
	dw adr
	db flag
	ENDM

	MACRO POTION id,type,dur,uadr,aadr,nadr
	db id,type,0,dur,0
	dw uadr,aadr,nadr
	ENDM
potionDSCSize=11

	MACRO MAGIC id,flag,mp,exeadr,txtadr
	db id,flag,mp
	dw exeadr,txtadr
	ENDM
magicDSCSize=7

	MACRO CRAFT id1,id2,resIcon,sadr
	db id1,id2,resIcon
	dw sadr
	ENDM
	
	MACRO EQUIP f1,f2,f3,f4,nadr,iadr
	db f1,f2,f3,f4
	dw nadr,iadr
	ENDM
	
	MACRO AMULET type,aadr,nadr,iadr
	db type,0
	dw aadr,nadr,iadr
	ENDM

; menu punkts

	MACRO mPunkt cnd,txtadr,data,execadr
	 db cnd,data
	 dw execadr,txtadr
	ENDM
	
	MACRO mText txtadr
	 db 0xfe,0
	 dw 0,txtadr
	ENDM
	
	MACRO mPunktBit n,txtadr,data,execadr
	 db 6,n,data
	 dw execadr,txtadr
	ENDM

; SCRIPT

	MACRO tEnd
	db 0
	ENDM

; 1:dialog

;	MACRO tDialog
;	db 1,1
;	ENDM
	
	MACRO tDialogOff
	db 1,0
	ENDM

	MACRO tMenu x,y,flag,callback,adr
	db 1,2,x,y,flag
	dw callback,adr
	ENDM
	
; 2:items, equip

	MACRO tDelItem id
	db 2,0,id
	ENDM

	MACRO tAddItem id
	db 2,1,id
	ENDM

	MACRO tAddItems id,cnt
	db 2,2,id,cnt
	ENDM
	
	MACRO tAddEquip id,num
	db 2,3,id,num
	ENDM
	
	MACRO tDelEquip id,num
	db 2,4,id,num
	ENDM
	
	MACRO tAddPotion id
	db 2,5,id
	ENDM
	
	MACRO tDelPotion id
	db 2,6,id
	ENDM
	
	MACRO tPutItem id,map,x,y
	db 2,7,id,map,x,y
	ENDM
	
	MACRO tRotateBag fl
	db 2,8,fl
	ENDM
	
	MACRO tAddMagic id
	db 2,9,id
	ENDM
	
	MACRO tDelMagic id
	db 2,10,id
	ENDM
	
	MACRO tDrawBag
	db 2,11
	ENDM
	
; 3:bits & vars

	MACRO tResBit n
	db 3,0,n
	ENDM

	MACRO tSetBit n
	db 3,1,n
	ENDM
	
	MACRO tInvBit n
	db 3,2,n
	ENDM
	
	MACRO tVarSet n,x
	db 3,16,n,x
	ENDM
	
	MACRO tVarCopy n,m
	db 3,17,n,m
	ENDM
	
	MACRO tVarAdd n,x
	db 3,18,n,x
	ENDM
	
	MACRO tVarSum n,m
	db 3,19,n,m
	ENDM
	
	MACRO tVarSub n,x
	db 3,20,n,x
	ENDM
	
	MACRO tVarDiff n,m
	db 3,21,n,m
	ENDM

; 4 : npc,elems,doors,zones

	MACRO tNpcAni n,adr
	db 4,0,n
	dw adr
	ENDM

	MACRO tMapAni n,adr
	db 4,1,n
	dw adr
	ENDM
	
	MACRO tDoorOn id
	db 4,2,id
	ENDM
	
	MACRO tDoorOff id
	db 4,3,id
	ENDM

	MACRO tMapSpr n,adr
	db 4,4,n
	dw adr
	ENDM
	
	MACRO tMoveNPC id,map,x,y
	db 4,5,id,map,x,y
	ENDM
	
	MACRO tMoveElem id,map,x,y
	db 4,6,id,map,x,y
	ENDM
	
	MACRO tNpcSpr id,adr
	db 4,7,id
	dw adr
	ENDM
	
	MACRO tElemOff id
	db 4,8,id,0,0
	ENDM
	
	MACRO tElemOn id,adr
	db 4,8,id
	dw adr
	ENDM
	
	MACRO tWaitNPC id
	db 4,9,id
	ENDM

	MACRO tZoneOn id
	db 4,10,id
	ENDM
	
	MACRO tZoneOff id
	db 4,11,id
	ENDM
	
	MACRO tZoneScan adr
	db 4,12
	dw adr
	ENDM
	
	MACRO tWaitElem id
	db 4,13,id
	ENDM

; 5:info line

	MACRO tInfoProgress hp,mp
	db 5,0,hp,mp
	ENDM
	
	MACRO tInfoText txt
	db 5,1,txt,0
	ENDM

	MACRO tShowItemName
	db 5,2
	ENDM
	
	MACRO tDrawRow lay,x,y,txt
	db 5,3,lay,x,y,txt,0
	ENDM
	
	MACRO tClearRect lay,x,y,dx,dy
	db 5,4,lay,x,y,dx,dy
	ENDM

; 6:battle stuffs

	MACRO tAddHP id,n
	db 6,0,id,n
	ENDM
	
	MACRO tDelHP id,n
	db 6,1,id,n
	ENDM
	
	MACRO tAddMP id,n
	db 6,2,id,n
	ENDM
	
	MACRO tDelMP id,n
	db 6,3,id,n
	ENDM
	
	MACRO tSelectEnemy n,adr
	db 6,4,n
	dw adr
	ENDM
	
	MACRO tPickEnemy n
	db 6,5,n
	ENDM
	
	MACRO tAttack id1,id2,adr
	db 6,6,id1,id2
	dw adr
	ENDM
	
	MACRO tBattleInfoWindow flag
	db 6,7,flag
	ENDM

	MACRO tBattleScript id,sid
	db 6,8,id,sid
	ENDM
	
	MACRO tCheckNPC id,state,adr
	db 6,9,id,state
	dw adr
	ENDM

	MACRO tMagicMenu
	db 6,10
	ENDM
	
	MACRO tBattleCancelTurn
	db 6,11
	ENDM
	
	MACRO tPotionMenu
	db 6,12
	ENDM
	
	MACRO tIfBattleHPLess id,n,adr
	db 6,13,id,n
	dw adr
	ENDM
	
	MACRO tBattleSetHP id,n
	db 6,14,id,n
	ENDM
	
	MACRO tBattleCurrent n,id
	db 6,15,n,id
	ENDM
	
	MACRO tActPotion id
	db 6,16,id
	ENDM
	
	MACRO tSetAttack id,adr
	db 6,17,id
	dw adr
	ENDM
	
	MACRO tSetDefence id,adr
	db 6,18,id
	dw adr
	ENDM
	
	MACRO tSetActions id,adr
	db 6,19,id
	dw adr
	ENDM
	
	MACRO tRaiseMaxHP id,prc
	db 6,20,id,prc
	ENDM
	
	MACRO tRaiseDamage prc
	db 6,21,prc
	ENDM
	
	MACRO tReduceDamage prc
	db 6,22,prc
	ENDM
	
	MACRO tSetDamage num
	db 6,23,num
	ENDM

	MACRO tRaiseHP id,prc
	db 6,24,id,prc
	ENDM
	
	MACRO tBattleStart
	db 6,25
	ENDM
	
	MACRO tBattleWin
	db 6,26
	ENDM
	
	MACRO tBattleLose
	db 6,27
	ENDM
	
	MACRO tIfBattleWin adr
	db 6,28
	dw adr
	ENDM
	
	MACRO tIfBattleLose adr
	db 6,29
	dw adr
	ENDM
	
	MACRO tBattleTurn
	db 6,30
	ENDM
	
	MACRO tAffect id
	db 6,31,id
	ENDM
	
	MACRO tRaiseMP id,prc
	db 6,32,id,prc
	ENDM
	
	MACRO tSelectAlly n,adr
	db 6,33,n
	dw adr
	ENDM
	
	MACRO tPickAlly n
	db 6,34,n
	ENDM
	
	MACRO tBattleCancel n
	db 6,35,n
	ENDM

; 7:game actions

	MACRO tActionTalk adr
	db 7,0
	dw adr
	ENDM
	
	MACRO tActionGive adr
	db 7,1
	dw adr
	ENDM
	
	MACRO tActionPickUp
	db 7,2
	ENDM
	
	MACRO tActionDrop
	db 7,3
	ENDM
	
	MACRO tActionAffect
	db 7,4
	ENDM
	
	MACRO tActionUse adr
	db 7,5
	dw adr
	ENDM

	MACRO tSelectEquip
	db 7,6
	ENDM
	
	MACRO tActionCraft
	db 7,7
	ENDM

; 8:game control

	MACRO tKeyScan adr
	db 8,0
	dw adr
	ENDM

	MACRO tInitData
	db 8,1
	ENDM
	
	MACRO tBorder col
	db 8,2,col
	ENDM

	MACRO tInitHero hp,mp,adr
	db 8,4,hp,mp
	dw adr
	ENDM

	MACRO tBreakPoint
	db 8,5
	ENDM
	
	MACRO tInitLayers mbits,bbits
	db 8,6,mbits,bbits
	ENDM

	MACRO tInitViewport x,y,dx,dy
	db 8,7,x,y,dx,dy
	ENDM
	
	MACRO tFillAtrs atr
	db 8,8,atr
	ENDM
	
	MACRO tGCls atr
	db 8,9,atr
	ENDM
	
	MACRO tACls atr
	db 8,10,atr
	ENDM
	
	MACRO tDepack src,dst
	db 8,11
	dw src,dst
	ENDM
	
	MACRO tDrawSprite dx,dy,adr,scr
	db 8,12,dx,dy
	dw adr,scr
	ENDM
	
	MACRO tFillMem adr,len,val
	db 8,13,val,len
	dw adr
	ENDM

	MACRO tInitMap msk
	db 8,14,msk
	ENDM
	
	MACRO tInitColor cadr
	db 8,15
	dw cadr
	ENDM
	
; 09:music

	MACRO tMuzSwitch n
	db 9,0,n
	ENDM
	
	MACRO tMuzPlay id
	db 9,1,id
	ENDM
	
	MACRO tPlaySFX id
	db 9,2,id
	ENDM

; 1e:misc

	MACRO tHalt
	db 0x1e,0
	ENDM
	
	MACRO tBattle id,adr
	db 0x1e,1,id
	dw adr
	ENDM

	MACRO tCraftClear
	db 0x1e,2
	ENDM
	
	MACRO tExtend adr
	db 0x1e,3
	dw adr
	ENDM
	
	MACRO tWaitKey
	db 0x1e,4
	ENDM
	
	MACRO tAnimation flag
	db 0x1e,5,flag
	ENDM

	MACRO tPause n
	db 0x1e,6,n
	ENDM
	
	MACRO tCall adr
	db 0x1e,7
	dw adr
	ENDM
	
	MACRO tExec adr
	db 0x1e,8
	dw adr
	ENDM
	
	MACRO tSetMap n
	db 0x1e,9,n
	ENDM
	
	MACRO tRestore
	db 0x1e,10
	ENDM
	
	MACRO tRestart
	db 0x1e,11
	ENDM
	
	MACRO tTurnL7 flg
	db 0x1e,12,flg
	ENDM

; 1f:conditions & jumps

	MACRO tIfRes n,adr
	db 0x1f,0x00,n
	dw adr
	ENDM
	
	MACRO tIfSet n,adr
	db 0x1f,0x01,n
	dw adr
	ENDM
	
	MACRO tJump adr
	db 0x1f,0x02
	dw adr
	ENDM
/*
	MACRO tIfHaveItem id,adr
	db 0x1f,0x03,id
	dw adr
	ENDM
*/
	MACRO tIfVarEqual n,x,adr
	db 0x1f,0x04,n,x
	dw adr
	ENDM
	
	MACRO tIfVarsEqual n,m,adr
	db 0x1f,0x05,n,m
	dw adr
	ENDM
	
	MACRO tIfVarLess n,x,adr
	db 0x1f,0x06,n,x
	dw adr
	ENDM
	
	MACRO tIfVarLessVar n,m,adr
	db 0x1f,0x07,n,m
	dw adr
	ENDM
	
	MACRO tIfVarNotEqual n,x,adr
	db 0x1f,0x08,n,x
	dw adr
	ENDM
	
	MACRO tIfVarNotVar n,m,adr
	db 0x1f,0x09,n,m
	dw adr
	ENDM
	
	MACRO tIfNPC n,adr
	db 0x1f,0x0a,n
	dw adr
	ENDM
	
	MACRO tIfElement n,adr
	db 0x1f,0x0b,n
	dw adr
	ENDM
	
	MACRO tIfNPCanim id,adr
	db 0x1f,0x0c,id
	dw adr
	ENDM
	
	MACRO tIfRndLess num,adr
	db 0x1f,0x0e,num
	dw adr
	ENDM
	
	MACRO tIfVarAnd num,msk,adr
	db 0x1f,0x0f,num,msk
	dw adr
	ENDM
	
	MACRO tIfRndAnd msk,adr
	db 0x1f,0x10,msk
	dw adr
	ENDM
	
	MACRO tIfHaveItem id,adr
	db 0x1f,0x11,id
	dw adr
	ENDM
	
	MACRO tIfHaveMagic id,adr
	db 0x1f,0x12,id
	dw adr
	ENDM
	
	MACRO tIfHavePotion id,adr
	db 0x1f,0x13,id
	dw adr
	ENDM
	
	MACRO tIfCancel adr
	db 0x1f,0x14
	dw adr
	ENDM

; ANIMATIONS

	MACRO aEnd
	db 0
	ENDM
	
; F0 : sprite

	MACRO aMoveDir dir
	db 0xf0,0,dir
	ENDM

	MACRO aSetDir dir
	db 0xf0,1,dir
	ENDM
	
	MACRO aChangeMap dir
	db 0xf0,2,dir
	ENDM
	
	MACRO aSetVisible n
	db 0xf0,3,n
	ENDM

	MACRO aMoveTo x,y
	db 0xf0,4,x,y
	ENDM
	
	MACRO aShift dx,dy
	db 0xf0,5,dx,dy
	ENDM
	
; F1 : vars & bits
	
	MACRO aResBit n
	db 0xf1,0,n
	ENDM
	
	MACRO aSetBit n
	db 0xf1,1,n
	ENDM
	
	MACRO aInvBit n
	db 0xf1,2,n
	ENDM
	
	MACRO aSetVar n,x
	db 0xf1,16,n,x
	ENDM

	MACRO aSubX n,x
	db 0xf1,20,n,x
	ENDM

; F2 : misc

	MACRO aChkDoor adr
	db 0xf2,0
	dw adr
	ENDM
	
	MACRO aScript adr
	db 0xf2,1
	dw adr
	ENDM
	
	MACRO aPlaySFX id
	db 0xf2,2,id
	ENDM
	
; F3 : cycle

	MACRO aCycle n
	db 0xf3,0,n
	ENDM
	
	MACRO aEndCycle
	db 0xf3,1
	ENDM

; FF : conditions jumps
	
	MACRO aJump adr
	db 0xff,0xff
	dw adr
	ENDM

	MACRO aIfRes n,adr
	db 0xff,0,n
	dw adr
	ENDM
	
	MACRO aIfSet n,adr
	db 0xff,1,n
	dw adr
	ENDM

	MACRO aIfXEqual n,adr
	db 0xff,2,n
	dw adr
	ENDM
	
	MACRO aIfYEqual n,adr
	db 0xff,3,n
	dw adr
	ENDM
	
	MACRO aCheckDir dir,adr
	db 0xff,4,dir
	dw adr
	ENDM
	
	MACRO aIfDirNot dir,adr
	db 0xff,5,dir
	dw adr
	ENDM
	
	MACRO aCheckMap dir,adr
	db 0xff,6,dir
	dw adr
	ENDM
	
	MACRO aIfRndLess num,adr
	db 0xff,7,num
	dw adr
	ENDM
	
	MACRO aIfVarEqual n,m,adr
	db 0xff,8,n,m
	dw adr
	ENDM
	
	MACRO aIfVarNot n,m,adr
	db 0xff,9,n,m
	dw adr
	ENDM