@echo off

FOR %%I IN (*.wav) DO (
    sox -S "%%I" -b 8 -c 1 -e unsigned-integer -r 18816 "%%I.0.raw" vol 0.015625
    sox -S "%%I" -b 8 -c 1 -e unsigned-integer -r 18816 "%%I.1.raw" vol 0.031250
    sox -S "%%I" -b 8 -c 1 -e unsigned-integer -r 18816 "%%I.2.raw" vol 0.046875
    sox -S "%%I" -b 8 -c 1 -e unsigned-integer -r 18816 "%%I.3.raw" vol 0.062500
    sox -S "%%I" -b 8 -c 1 -e unsigned-integer -r 18816 "%%I.4.raw" vol 0.078125
    sox -S "%%I" -b 8 -c 1 -e unsigned-integer -r 18816 "%%I.5.raw" vol 0.093750
    sox -S "%%I" -b 8 -c 1 -e unsigned-integer -r 18816 "%%I.6.raw" vol 0.109375
    sox -S "%%I" -b 8 -c 1 -e unsigned-integer -r 18816 "%%I.7.raw" vol 0.125000
    sox -S "%%I" -b 8 -c 1 -e unsigned-integer -r 18816 "%%I.8.raw" vol 0.140625
    sox -S "%%I" -b 8 -c 1 -e unsigned-integer -r 18816 "%%I.9.raw" vol 0.156250
    sox -S "%%I" -b 8 -c 1 -e unsigned-integer -r 18816 "%%I.a.raw" vol 0.171875
    sox -S "%%I" -b 8 -c 1 -e unsigned-integer -r 18816 "%%I.b.raw" vol 0.187500
    sox -S "%%I" -b 8 -c 1 -e unsigned-integer -r 18816 "%%I.c.raw" vol 0.203125
    sox -S "%%I" -b 8 -c 1 -e unsigned-integer -r 18816 "%%I.d.raw" vol 0.218750
    sox -S "%%I" -b 8 -c 1 -e unsigned-integer -r 18816 "%%I.e.raw" vol 0.234375
    sox -S "%%I" -b 8 -c 1 -e unsigned-integer -r 18816 "%%I.f.raw" vol 0.250000
)

rem -b 8        -   bit depth = 8

rem -c 1        -   a single output channel

rem -e unsign...-   unsigned integer encoding

rem -r 18816    -   waveforms are 600 samples long (but we want 256):
rem                 (44100 * 256 / 600 = 18816)

rem vol 0.25    -   quarter volume (designed for 4 channels)
rem             -   volume = ((index + 1) / 16 * 0.25)
rem             -          = ((index + 1) / 64)
