zeusemulate "128K"

CONTENDED_BANK_0    equ 1
CONTENDED_BANK_1    equ 3
NONCONTENDED_BANK_0 equ 4
NONCONTENDED_BANK_1 equ 6

USE_YM_TABLE equ 0
OUTPUT_METHOD equ OUTPUT_AY_MONO

INCLUDE_LOADER equ false

    ; AY file header

    ; NOTE - words are big-endian
    ; and must be aligned at 2 byte offsets

org $4000
ay_header_start:

    db "ZXAY"               ; FileID            longword
    db "EMUL"               ; TypeID            longword
    db 0                    ; FileVersion       byte
    db 0                    ; PlayerVersion     byte
    defwbe 0                ; PSpecialPlayer    smallint
    defwbe Author - $       ; PAuthor           smallint
    defwbe Misc - $         ; PMisc             smallint
    db 1 -1                 ; NumOfSongs        byte
    db 1 -1                 ; FirstSong         byte
    defwbe SongStructure - $; PSongsStructure   smallint

SongStructure:
    defwbe SongName - $     ; PSongName         smallint
    defwbe SongData - $     ; PSongData         smallint

SongData:
    db 0                    ; AChan             byte
    db 1                    ; BChan             byte
    db 2                    ; CChan             byte
    db 3                    ; Noise             byte
    defwbe 0                ; SongLength        word
    defwbe 0                ; FadeLength        word
    db 0                    ; HiReg             byte
    db 0                    ; LoReg             byte
    defwbe Points - $       ; PPoints           smallint
    defwbe Addresses - $    ; PAddresses        smallint

Points:

    defwbe 0                ; Stack             word
    defwbe setup            ; Init              word
    defwbe 0                ; Inter             word

Addresses:

    defwbe Bank0_Start      ; Address1          word
    defwbe Bank0_Size       ; Length1           word
    defwbe Bank0 - $        ; Offset1           word

    defwbe Bank2_Start      ; Address2          word
    defwbe Bank2_Size       ; Length2           word
    defwbe Bank2 - $        ; Offset2           word

    defwbe Bank5_Start      ; Address3          word
    defwbe Bank5_Size       ; Length3           word
    defwbe Bank5 - $        ; Offset3           word

    defwbe 0                ; ENDWORD           word

Author:

    db "djnzx", 0

Misc:

    db 0

SongName:

    db "Hey Nineteen", 0

ay_header_end:

Bank0 equ ay_header_end
Bank2 equ Bank0 + Bank0_Size
Bank5 equ Bank2 + Bank2_Size

Bank0_Start equ bank_start_0
Bank0_Size equ bank_size_0

Bank2_Start equ bank_start_2
Bank2_Size equ bank_size_2

Bank5_Start equ bank_start_5 + $1b00
Bank5_Size equ bank_size_5 - $1b00

ay_header_size = ay_header_end - ay_header_start

output_bin "../bin/build/ir/ay/header.bin", ay_header_start, ay_header_size

include "synth.asm"

output_bin "../bin/build/ir/ay/loadscr.bin", $4000, $1b00
output_bin "../bin/build/ir/ay/bank0.bin", bank_start_0, bank_size_0
output_bin "../bin/build/ir/ay/bank2.bin", bank_start_2, bank_size_2
output_bin "../bin/build/ir/ay/bank5.bin", bank_start_5 + $1b00, bank_size_5 - $1b00

output_list "../bin/build/ir/ay/synth.list"
