#!/usr/bin/env bash

ZEUS_DIR="tools/zeus"
BUILD_DIR="bin/build"
INTERMEDIATE_DIR="${BUILD_DIR}/ir"

git_version=$(git describe --long --tags --dirty --always)
build_name_ay="synth-${git_version}"

if ! [ -d "$BUILD_DIR" ]; then
    mkdir -p "$BUILD_DIR"
fi

if [ -d "$INTERMEDIATE_DIR" ]; then
    rm -r -- "$INTERMEDIATE_DIR"
fi
mkdir "$INTERMEDIATE_DIR"

mkdir "$INTERMEDIATE_DIR/ay"

echo Building $build_name_ay...

if [ "$1" != "--no-wine" ]; then
    USE_WINE='wine'
fi

echo
(cd src && exec ${USE_WINE} ../${ZEUS_DIR}/zcl.exe synth_ay.asm)

cat ${INTERMEDIATE_DIR}/ay/header.bin \
    ${INTERMEDIATE_DIR}/ay/bank0.bin \
    ${INTERMEDIATE_DIR}/ay/bank2.bin \
    ${INTERMEDIATE_DIR}/ay/bank5.bin > ${BUILD_DIR}/${build_name_ay}.ay

echo -e 'synth build successful.'
