;bm-1 demo song

;************************************************************************************************************************************************
;song sequence
	dw ptn3
	dw ptn4
mloop			;sequence loop point (mandatory)
	dw ptn5
	dw ptn5
	dw ptn6
	dw ptn7
	dw 0		;sequence end marker (mandatory)
	
;************************************************************************************************************************************************
;pattern data
;
;DATA FORMAT:	ctrl0/drum param|0 (Z = end, C=no updates, PV = drum1, M = drum2)
;		ctrl1/patch1_7 (Z = no patch update, PV = skip patch 1-6, S = skip patch 8-11, C = skip all)
;			[patch_ptr, div1, [(if div1&0x8000) param1]]
;		ctrl2/patch2_7 (Z = no patch update, PV = skip patch 1-6, S = skip patch 8-11, C = skip all)
;			[patch_ptr, div2, [(if div2&0x8000) param2]]
;		ctrl3/speed (Z = no tbl_ptr update)
;
;
;          dr_cfg p1_7   patch1  div1	par1    p2_7   patch2  div2   par2    speed  tbl_ptr
;          ctrl0  ctrl1                         ctrl2                         ctrl3

ptn3	dw #0000, #0f00, patch4, a3|#8000,#8010,#0000, patch0, rest,          #9000, arpvol1
	dw #0001, #9040
	dw #0000, #0040,         a3|#8000,#8010,#0001,                        #9000, arpvol2
	dw #0001, #9040
	dw #0000, #0040,         g3|#8000,#8010,#0001,                        #9000, arpvol3
	dw #0001, #9040
	dw #0000, #0040,         g3|#8000,#8010,#0001,                        #9000, arpvol4
	dw #0001, #9040
	db #40
	
ptn4	dw #0000, #0f00, patch4, a3|#8000,#8010,#9f00, patch3, a0|#8000,#8000,#9000, arpvol1
	dw #0001, #9040
	dw #0000, #0040,         a3|#8000,#8010,#0001,                        #9000, arpvol2
	dw #0001, #9040
	dw #0000, #0040,         g3|#8000,#8010,#0040,         g0|#8000,#8000,#9000, arpvol3
	dw #0001, #9040
	dw #0000, #0040,         g3|#8000,#8010,#0001,                        #9000, arpvol4
	dw #0000, #0001,                        #0040,         b0|#8000,#8000,#6c40
	dw #0000, #0001,                        #0040,         c1|#8000,#8000,#1240
	dw #0000, #0001,                        #0040,         b0|#8000,#8000,#1240
	db #40

ptn7	dw #0c04, #0f00, patch4, a3|#8000,#8010,#0700, patch2, a1,            #1200, arpvol1	;90
	dw #1080, #0001,                        #0001,			      #0940
	dw #1080, #0001,                        #0001,			      #0940
	dw #4080, #0001,                        #0f00, patch5, #a174,   #7040,#0340
	dw #0000, #0001,                        #0700, patch2, a1,            #0f40
	dw #1080, #0001,                        #0040,         ais1,          #0340
	dw #0000, #0001,                        #0040,         b1,            #0340
	dw #0000, #0001,                        #0040,         c2,            #0340
	dw #1080, #0001,                        #0040,         cis2,          #0340
	dw #0000, #0001,                        #0040,         d2,            #0340
	dw #0000, #0001,                        #0040,         dis2,          #0340
	
	dw #0c04, #0001,                        #0040,         e2,            #1240
	dw #1080, #0001,                        #0001,			      #0940
	dw #1080, #0001,                        #0001,			      #0940
	dw #4080, #0001,                        #0f00, patch5, #a174,   #7040,#0340
	dw #0000, #0001,                        #0700, patch2, e2,            #0f40
	dw #1080, #0001,                        #0001,                        #0940
	dw #1080, #0001,                        #0001,			      #0940
	
	dw #0c04, #0001,                        #0040,         e2,            #1240
	dw #1080, #0001,                        #0001,			      #0940
	dw #1080, #0001,                        #0001,			      #0940
	dw #4080, #0001,                        #0f00, patch5, #a174,   #7040,#0340
	dw #0000, #0001,                        #0700, patch2, e2,            #0f40
	dw #1080, #0001,                        #0001,                        #0940
	dw #1080, #0001,                        #0001,			      #0940
	
	dw #0c04, #0001,                        #0040,         e2,            #1240
	dw #1080, #0001,                        #0001,			      #0940
	dw #1080, #0001,                        #0001,			      #0940
	dw #4080, #0001,                        #0f00, patch5, #a174,   #7040,#0340
	dw #0000, #0001,                        #0700, patch2, e2,            #0f40
	dw #1080, #0001,                        #0001,                        #0940
	dw #1080, #0001,                        #0001,			      #0940
	
	dw #0c04, #0040,         a3|#8000,#8010,#0040,         g2,          #1200, arpvol2
	dw #1080, #0001,                        #0001,			      #0940
	dw #1080, #0001,                        #0001,			      #0940
	dw #4080, #0001,                        #0f00, patch5, #a174,   #7040,#0340
	dw #0000, #0001,                        #0700, patch2, g2,            #0f40
	dw #1080, #0001,                        #0040,         e2,            #0940
	dw #1080, #0001,                        #0040,	       d2,	      #0940
	
	dw #0c04, #0001,                        #0040,         e2,            #1240
	dw #1080, #0001,                        #0001,			      #0940
	dw #1080, #0001,                        #0001,			      #0940
	dw #4080, #0001,                        #0f00, patch5, #a174,   #7040,#0340
	dw #0000, #0001,                        #0700, patch2, e2,            #0f40
	dw #1080, #0001,                        #0001,                        #0940
	dw #1080, #0001,                        #0001,			      #0940
	
	dw #0c04, #0001,                        #0040,         e2,            #1240
	dw #1080, #0001,                        #0001,			      #0940
	dw #1080, #0001,                        #0001,			      #0940
	dw #4080, #0001,                        #0f00, patch5, #a174,   #7040,#0340
	dw #0000, #0001,                        #0700, patch2, e2,            #0f40
	dw #1080, #0001,                        #0001,                        #0940
	dw #1080, #0001,                        #0001,			      #0940
	
	dw #0c04, #0001,                        #0040,         e2,            #1240
	dw #1080, #0001,                        #0001,			      #0940
	dw #1080, #0001,                        #0001,			      #0940
	dw #4080, #0001,                        #0f00, patch5, #a174,   #7040,#0340
	dw #0000, #0001,                        #0700, patch2, e2,            #0f40
	dw #1080, #0001,                        #0001,                        #0940
	dw #1080, #0001,                        #0001,			      #0940
	
	dw #0c04, #0040,         g3|#8000,#8010,#0001,                        #1200, arpvol3
	dw #1080, #0001,                        #0001,			      #0940
	dw #1080, #0001,                        #0001,			      #0940
	dw #4080, #0001,                        #0f00, patch5, #a174,   #7040,#0340
	dw #0000, #0001,                        #0700, patch2, e2,            #0f40
	dw #1080, #0001,                        #0040,         d2,            #0940
	dw #1080, #0001,                        #0040,	       c2,	      #0940
	
	dw #0c04, #0001,                        #0040,         d2,            #1240
	dw #1080, #0001,                        #0001,			      #0940
	dw #1080, #0001,                        #0001,			      #0940
	dw #4080, #0001,                        #0f00, patch5, #a174,   #7040,#0340
	dw #0000, #0001,                        #0700, patch2, d2,            #0f40
	dw #1080, #0001,                        #0001,                        #0940
	dw #1080, #0001,                        #0001,			      #0940
	
	dw #0c04, #0001,                        #0040,         d2,            #1240
	dw #1080, #0001,                        #0001,			      #0940
	dw #1080, #0001,                        #0001,			      #0940
	dw #4080, #0001,                        #0f00, patch5, #a174,   #7040,#0340
	dw #0000, #0001,                        #0700, patch2, d2,            #0f40
	dw #1080, #0001,                        #0001,                        #0940
	dw #1080, #0001,                        #0001,			      #0940
	
	dw #0c04, #0001,                        #0040,         d2,            #1240
	dw #1080, #0001,                        #0001,			      #0940
	dw #1080, #0001,                        #0001,			      #0940
	dw #4080, #0001,                        #0f00, patch5, #a174,   #7040,#0340
	dw #0000, #0001,                        #0700, patch2, d2,            #0f40
	dw #1080, #0001,                        #0001,                        #0940
	dw #1080, #0001,                        #0001,			      #0940
	
	dw #0c04, #0040,         g3|#8000,#8010,#0040,         e2,          #1200, arpvol4
	dw #1080, #0001,                        #0001,			      #0940
	dw #1080, #0001,                        #0001,			      #0940
	dw #4080, #0001,                        #0f00, patch5, #a174,   #7040,#0340
	dw #0000, #0001,                        #0700, patch2, e2,            #0f40
	dw #1080, #0001,                        #0040,         d2,            #0940
	dw #1080, #0001,                        #0040,	       c2,	      #0940
	
	dw #0c04, #0001,                        #0040,         d2,            #1240
	dw #1080, #0001,                        #0001,			      #0940
	dw #1080, #0001,                        #0001,			      #0940
	dw #4080, #0001,                        #0f00, patch5, #a174,   #7040,#0340
	dw #0000, #0001,                        #0700, patch2, d2,            #0f40
	dw #1080, #0001,                        #0001,                        #0940
	dw #1080, #0001,                        #0001,			      #0940
	
	dw #0c04, #0001,                        #0040,         d2,            #1240
	dw #1080, #0001,                        #0001,			      #0940
	dw #1080, #0001,                        #0001,			      #0940
	dw #4080, #0001,                        #0f00, patch5, #a174,   #7040,#0340
	dw #0000, #0001,                        #0700, patch2, d2,            #0f40
	dw #1080, #0001,                        #0001,                        #0940
	dw #1080, #0001,                        #0001,			      #0940
	
	dw #0c04, #0001,                        #0040,         d2,            #1240
	dw #1080, #0001,                        #0001,			      #0940
	dw #1080, #0001,                        #0001,			      #0940
	dw #4080, #0001,                        #0f00, patch5, #a174,   #7040,#0340
	dw #0000, #0001,                        #0700, patch2, d2,            #0f40
	dw #0c04, #0001,                        #0040,         c2,            #0940
	dw #0c04, #0001,                        #0040,	       b1,	      #0940
	db #40




ptn6	dw #0c04, #0f00, patch4, a3|#8000,#8010,#0f00, patch1, a1,            #1200, arpvol1	;90
	dw #0000, #0001,                        #0001,			      #0940
	dw #0000, #0001,                        #0001,			      #0940
	dw #4080, #0001,                        #0f00, patch5, #a174,   #7040,#0340
	dw #0000, #0001,                        #0f00, patch1, a1,            #0f40
	dw #0000, #0001,                        #0040,         ais1,          #0340
	dw #0000, #0001,                        #0040,         b1,            #0340
	dw #0000, #0001,                        #0040,         c2,            #0340
	dw #0000, #0001,                        #0040,         cis2,          #0340
	dw #0000, #0001,                        #0040,         d2,            #0340
	dw #0000, #0001,                        #0040,         dis2,          #0340
	
	dw #0c04, #0001,                        #0040,         e2,            #1240
	dw #0000, #0001,                        #0001,			      #0940
	dw #0000, #0001,                        #0001,			      #0940
	dw #4080, #0001,                        #0f00, patch5, #a174,   #7040,#0340
	dw #0000, #0001,                        #0f00, patch1, e2,            #0f40
	dw #0000, #0001,                        #0001,                        #0940
	dw #0000, #0001,                        #0001,			      #0940
	
	dw #0c04, #0001,                        #0040,         e2,            #1240
	dw #0000, #0001,                        #0001,			      #0940
	dw #0000, #0001,                        #0001,			      #0940
	dw #4080, #0001,                        #0f00, patch5, #a174,   #7040,#0340
	dw #0000, #0001,                        #0f00, patch1, e2,            #0f40
	dw #0000, #0001,                        #0001,                        #0940
	dw #0000, #0001,                        #0001,			      #0940
	
	dw #0c04, #0001,                        #0040,         e2,            #1240
	dw #0000, #0001,                        #0001,			      #0940
	dw #0000, #0001,                        #0001,			      #0940
	dw #4080, #0001,                        #0f00, patch5, #a174,   #7040,#0340
	dw #0000, #0001,                        #0f00, patch1, e2,            #0f40
	dw #0000, #0001,                        #0001,                        #0940
	dw #0000, #0001,                        #0001,			      #0940
	
	dw #0c04, #0040,         a3|#8000,#8010,#0040,         g2,          #1200, arpvol2
	dw #0000, #0001,                        #0001,			      #0940
	dw #0000, #0001,                        #0001,			      #0940
	dw #4080, #0001,                        #0f00, patch5, #a174,   #7040,#0340
	dw #0000, #0001,                        #0f00, patch1, g2,            #0f40
	dw #0000, #0001,                        #0040,         e2,            #0940
	dw #0000, #0001,                        #0040,	       d2,	      #0940
	
	dw #0c04, #0001,                        #0040,         e2,            #1240
	dw #0000, #0001,                        #0001,			      #0940
	dw #0000, #0001,                        #0001,			      #0940
	dw #4080, #0001,                        #0f00, patch5, #a174,   #7040,#0340
	dw #0000, #0001,                        #0f00, patch1, e2,            #0f40
	dw #0000, #0001,                        #0001,                        #0940
	dw #0000, #0001,                        #0001,			      #0940
	
	dw #0c04, #0001,                        #0040,         e2,            #1240
	dw #0000, #0001,                        #0001,			      #0940
	dw #0000, #0001,                        #0001,			      #0940
	dw #4080, #0001,                        #0f00, patch5, #a174,   #7040,#0340
	dw #0000, #0001,                        #0f00, patch1, e2,            #0f40
	dw #0000, #0001,                        #0001,                        #0940
	dw #0000, #0001,                        #0001,			      #0940
	
	dw #0c04, #0001,                        #0040,         e2,            #1240
	dw #0000, #0001,                        #0001,			      #0940
	dw #0000, #0001,                        #0001,			      #0940
	dw #4080, #0001,                        #0f00, patch5, #a174,   #7040,#0340
	dw #0000, #0001,                        #0f00, patch1, e2,            #0f40
	dw #0c04, #0001,                        #0001,                        #0940
	dw #0000, #0001,                        #0001,			      #0940
	
	dw #0c04, #0040,         g3|#8000,#8010,#0001,                        #1200, arpvol3
	dw #0000, #0001,                        #0001,			      #0940
	dw #0000, #0001,                        #0001,			      #0940
	dw #4080, #0001,                        #0f00, patch5, #a174,   #7040,#0340
	dw #0000, #0001,                        #0f00, patch1, e2,            #0f40
	dw #0000, #0001,                        #0040,         d2,            #0940
	dw #0000, #0001,                        #0040,	       c2,	      #0940
	
	dw #0c04, #0001,                        #0040,         d2,            #1240
	dw #0000, #0001,                        #0001,			      #0940
	dw #0000, #0001,                        #0001,			      #0940
	dw #4080, #0001,                        #0f00, patch5, #a174,   #7040,#0340
	dw #0000, #0001,                        #0f00, patch1, d2,            #0f40
	dw #0000, #0001,                        #0001,                        #0940
	dw #0000, #0001,                        #0001,			      #0940
	
	dw #0c04, #0001,                        #0040,         d2,            #1240
	dw #0000, #0001,                        #0001,			      #0940
	dw #0000, #0001,                        #0001,			      #0940
	dw #4080, #0001,                        #0f00, patch5, #a174,   #7040,#0340
	dw #0000, #0001,                        #0f00, patch1, d2,            #0f40
	dw #0000, #0001,                        #0001,                        #0940
	dw #0000, #0001,                        #0001,			      #0940
	
	dw #0c04, #0001,                        #0040,         d2,            #1240
	dw #0000, #0001,                        #0001,			      #0940
	dw #0000, #0001,                        #0001,			      #0940
	dw #4080, #0001,                        #0f00, patch5, #a174,   #7040,#0340
	dw #0000, #0001,                        #0f00, patch1, d2,            #0f40
	dw #0000, #0001,                        #0001,                        #0940
	dw #0000, #0001,                        #0001,			      #0940
	
	dw #0c04, #0040,         g3|#8000,#8010,#0040,         e2,          #1200, arpvol4
	dw #0000, #0001,                        #0001,			      #0940
	dw #0000, #0001,                        #0001,			      #0940
	dw #4080, #0001,                        #0f00, patch5, #a174,   #7040,#0340
	dw #0000, #0001,                        #0f00, patch1, e2,            #0f40
	dw #0000, #0001,                        #0040,         d2,            #0940
	dw #0000, #0001,                        #0040,	       c2,	      #0940
	
	dw #0c04, #0001,                        #0040,         d2,            #1240
	dw #0000, #0001,                        #0001,			      #0940
	dw #0000, #0001,                        #0001,			      #0940
	dw #4080, #0001,                        #0f00, patch5, #a174,   #7040,#0340
	dw #0000, #0001,                        #0f00, patch1, d2,            #0f40
	dw #0000, #0001,                        #0001,                        #0940
	dw #0000, #0001,                        #0001,			      #0940
	
	dw #0c04, #0001,                        #0040,         d2,            #1240
	dw #0000, #0001,                        #0001,			      #0940
	dw #0000, #0001,                        #0001,			      #0940
	dw #4080, #0001,                        #0f00, patch5, #a174,   #7040,#0340
	dw #0000, #0001,                        #0f00, patch1, d2,            #0f40
	dw #0000, #0001,                        #0001,                        #0940
	dw #0000, #0001,                        #0001,			      #0940
	
	dw #0c04, #0001,                        #0040,         d2,            #1240
	dw #0000, #0001,                        #0001,			      #0940
	dw #0000, #0001,                        #0001,			      #0940
	dw #4080, #0001,                        #0f00, patch5, #a174,   #7040,#0340
	dw #0000, #0001,                        #0f00, patch1, d2,            #0f40
	dw #0c04, #0001,                        #0040,         c2,            #0940
	dw #0c04, #0001,                        #0040,	       b1,	      #0940
	db #40

	
ptn5	dw #0c04, #0f00, patch4, a3|#8000,#8010,#9f00, patch3, rest,          #1200, arpvol1	;90
	dw #1080, #0001,                        #0040,         a0|#8000,#6000,#0940
	dw #1080, #0001,                        #0001,			      #0940
	dw #4080, #0001,                        #0f00, patch5, #a174,   #7040,#0640
	dw #0000, #0001,                        #9f00, patch3, rest,          #0c40
	dw #1080, #0001,                        #0040,         a0|#8000,#6000,#0940
	dw #1080, #0001,                        #0001,			      #0940
	
	dw #0c04, #0001,                        #0040,         rest,          #1240
	dw #1080, #0001,                        #0040,         a0|#8000,#6000,#0940
	dw #1080, #0001,                        #0001,			      #0940
	dw #4080, #0001,                        #0f00, patch5, #a174,   #7040,#0640
	dw #0000, #0001,                        #9f00, patch3, rest,          #0c40
	dw #1080, #0001,                        #0040,         a0|#8000,#6000,#0940
	dw #1080, #0001,                        #0001,			      #0940
	
	dw #0c04, #0001,                        #0040,         rest,          #1240
	dw #1080, #0001,                        #0040,         a0|#8000,#6000,#0940
	dw #1080, #0001,                        #0001,			      #0940
	dw #4080, #0001,                        #0f00, patch5, #a174,   #7040,#0640
	dw #0000, #0001,                        #9f00, patch3, rest,          #0c40
	dw #1080, #0001,                        #0040,         a0|#8000,#6000,#0940
	dw #1080, #0001,                        #0001,			      #0940
	
	dw #0c04, #0001,                        #0040,         rest,          #1240
	dw #1080, #0001,                        #0040,         a0|#8000,#6000,#0940
	dw #1080, #0001,                        #0001,			      #0940
	dw #4080, #0001,                        #0f00, patch5, #a174,   #7040,#0640
	dw #0000, #0001,                        #9f00, patch3, rest,          #0c40
	dw #0c04, #0001,                        #0040,         a0|#8000,#6000,#0940
	dw #1080, #0001,                        #0001,			      #0940
	
	dw #0c04, #0040,         a3|#8000,#8010,#0040,         rest,          #1200, arpvol2
	dw #1080, #0001,                        #0040,         a0|#8000,#6000,#0940
	dw #1080, #0001,                        #0001,			      #0940
	dw #4080, #0001,                        #0f00, patch5, #a174,   #7040,#0640
	dw #0000, #0001,                        #9f00, patch3, rest,          #0c40
	dw #1080, #0001,                        #0040,         a0|#8000,#6000,#0940
	dw #1080, #0001,                        #0001,			      #0940
	
	dw #0c04, #0001,                        #0040,         rest,          #1240
	dw #1080, #0001,                        #0040,         a0|#8000,#6000,#0940
	dw #1080, #0001,                        #0001,			      #0940
	dw #4080, #0001,                        #0f00, patch5, #a174,   #7040,#0640
	dw #0000, #0001,                        #9f00, patch3, rest,          #0c40
	dw #1080, #0001,                        #0040,         a0|#8000,#6000,#0940
	dw #1080, #0001,                        #0001,			      #0940
	
	dw #0c04, #0001,                        #0040,         rest,          #1240
	dw #1080, #0001,                        #0040,         a0|#8000,#6000,#0940
	dw #1080, #0001,                        #0001,			      #0940
	dw #4080, #0001,                        #0f00, patch5, #a174,   #7040,#0640
	dw #0000, #0001,                        #9f00, patch3, rest,          #0c40
	dw #1080, #0001,                        #0040,         a0|#8000,#6000,#0940
	dw #1080, #0001,                        #0001,			      #0940
	
	dw #0c04, #0001,                        #0040,         rest,          #1240
	dw #1080, #0001,                        #0040,         a0|#8000,#6000,#0940
	dw #1080, #0001,                        #0001,			      #0940
	dw #4080, #0001,                        #0f00, patch5, #a174,   #7040,#0640
	dw #0000, #0001,                        #9f00, patch3, rest,          #0c40
	dw #1080, #0001,                        #0040,         a0|#8000,#6000,#0940
	dw #1080, #0001,                        #0001,			      #0940
	
	dw #0c04, #0040,         g3|#8000,#8010,#0040,         rest,          #1200, arpvol3
	dw #1080, #0001,                        #0040,         g0|#8000,#6000,#0940
	dw #1080, #0001,                        #0001,			      #0940
	dw #4080, #0001,                        #0f00, patch5, #a174,   #7040,#0640
	dw #0000, #0001,                        #9f00, patch3, rest,          #0c40
	dw #1080, #0001,                        #0040,         g0|#8000,#6000,#0940
	dw #1080, #0001,                        #0001,			      #0940
	
	dw #0c04, #0001,                        #0040,         rest,          #1240
	dw #1080, #0001,                        #0040,         g0|#8000,#6000,#0940
	dw #1080, #0001,                        #0001,			      #0940
	dw #4080, #0001,                        #0f00, patch5, #a174,   #7040,#0640
	dw #0000, #0001,                        #9f00, patch3, rest,          #0c40
	dw #1080, #0001,                        #0040,         g0|#8000,#6000,#0940
	dw #1080, #0001,                        #0001,			      #0940
	
	dw #0c04, #0001,                        #0040,         rest,          #1240
	dw #1080, #0001,                        #0040,         g0|#8000,#6000,#0940
	dw #1080, #0001,                        #0001,			      #0940
	dw #4080, #0001,                        #0f00, patch5, #a174,   #7040,#0640
	dw #0000, #0001,                        #9f00, patch3, rest,          #0c40
	dw #1080, #0001,                        #0040,         g0|#8000,#6000,#0940
	dw #1080, #0001,                        #0001,			      #0940
	
	dw #0c04, #0001,                        #0040,         rest,          #1240
	dw #1080, #0001,                        #0040,         g0|#8000,#6000,#0940
	dw #1080, #0001,                        #0001,			      #0940
	dw #4080, #0001,                        #0f00, patch5, #a174,   #7040,#0640
	dw #0000, #0001,                        #9f00, patch3, rest,          #0c40
	dw #0c04, #0001,                        #0040,         g0|#8000,#6000,#0940
	dw #1080, #0001,                        #0001,			      #0940
	
	dw #0c04, #0040,         g3|#8000,#8010,#0040,         rest,          #1200, arpvol4
	dw #1080, #0001,                        #0040,         g0|#8000,#6000,#0940
	dw #1080, #0001,                        #0001,			      #0940
	dw #4080, #0001,                        #0f00, patch5, #a174,   #7040,#0640
	dw #0000, #0001,                        #9f00, patch3, rest,          #0c40
	dw #1080, #0001,                        #0040,         g0|#8000,#6000,#0940
	dw #1080, #0001,                        #0001,			      #0940
	
	dw #0c04, #0001,                        #0040,         rest,          #1240
	dw #1080, #0001,                        #0040,         g0|#8000,#6000,#0940
	dw #1080, #0001,                        #0001,			      #0940
	dw #4080, #0001,                        #0f00, patch5, #a174,   #7040,#0640
	dw #0000, #0001,                        #9f00, patch3, rest,          #0c40
	dw #1080, #0001,                        #0040,         g0|#8000,#6000,#0940
	dw #1080, #0001,                        #0001,			      #0940
	
	dw #0c04, #0001,                        #0040,         rest,          #1240
	dw #1080, #0001,                        #0040,         b0|#8000,#6000,#0940
	dw #1080, #0001,                        #0001,			      #0940
	dw #4080, #0001,                        #0f00, patch5, #a174,   #7040,#0640
	dw #0000, #0001,                        #9f00, patch3, rest,          #0c40
	dw #1080, #0001,                        #0040,         b0|#8000,#6000,#0940
	dw #1080, #0001,                        #0001,			      #0940
	
	dw #0c04, #0001,                        #0040,         rest,          #1240
	dw #1080, #0001,                        #0040,         c1|#8000,#6000,#0940
	dw #1080, #0001,                        #0001,			      #0940
	dw #4080, #0001,                        #0f00, patch5, #a174,   #7040,#0640
	dw #0000, #0001,                        #9f00, patch3, rest,          #0c40
	dw #0c04, #0001,                        #0040,         b0|#8000,#6000,#0940
	dw #0c04, #0001,                        #0001,			      #0940
	db #40

	
;************************************************************************************************************************************************
;patch data
;4, 6, or 10 bytes of code, depending on ctrl1/ctrl2
	
patch0
	reset_all		;macro supplied by patches.h
	
patch1
	saw_wave
	
patch2				;expects param1_7 = #07 (rlca)		
	harmonics

patch3
	sid_sound_ch2

patch4
	duty_vol_ch1
	
patch5
	noise_vol_ch2

;************************************************************************************************************************************************
;fx table data
;
;tbl_flags: Z = stop tbl_exec, C= no update, S = tbl_jump, PV = execute function (addr follows)
;if no flags set or function executed that jumps to tblStdUpdate, second ctrlbyte follows: Z = skip freq_div1, C=skip generic_param1, 
;											   S = skip freq_div2, PV = skip generic_param2
;data follows in order: freq_div1, generic_param1, freq_div2, generic_param2

stopfx
	db #40

arpvol1
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, e4
	db #01
	db #01
	dw #0000, #0085, a3
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, e4
	db #01
	db #01
	dw #0000, #0084, a3, #8020
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, e4
	db #01
	db #01
	dw #0000, #0085, a3
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, e4
	db #01
	db #01
	dw #0000, #0084, a3, #8030
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, e4
	db #01
	db #01
	dw #0000, #0085, a3
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, e4
	db #01
	db #01
	dw #0000, #0084, a3, #8040
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, e4
	db #01
	db #01
	dw #0000, #0085, a3
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, e4
	db #01
	db #01
	dw #0000, #0084, a3, #8050
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, e4
	db #01
	db #01
	dw #0000, #0085, a3
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, e4
	db #01
	db #01
	dw #0000, #0084, a3, #8060
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, e4
	db #01
	db #01
	dw #0000, #0085, a3
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, e4
	db #01
	db #01
	dw #0000, #0084, a3, #8070
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, e4
	db #01
	db #01
	dw #0000, #0085, a3
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, e4
	db #01
	db #01
	dw #0000, #0084, a3, #8060
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, e4
	db #01
	db #01
	dw #0000, #0085, a3
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, e4
	db #01
	db #01
	dw #0000, #0084, a3, #8050
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, e4
	db #01
	db #01
	dw #0000, #0085, a3
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, e4
	db #01
	db #01
	dw #0000, #0084, a3, #8040
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, e4
	db #01
	db #01
	dw #0000, #0085, a3
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, e4
	db #01
	db #01
	dw #0000, #0084, a3, #8030
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, e4
	db #01
	db #01
	dw #0000, #0085, a3
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, e4
	db #01
	db #01
	dw #0000, #0084, a3, #8020
arpvol1lp
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, e4
	db #01
	db #01
	dw #0000, #0085, a3
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, e4
	db #01
	db #01
	dw #0000, #0084, a3, #8010
	dw #0080, arpvol1lp


arpvol2
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0085, a3
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0084, a3, #8020
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0085, a3
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0084, a3, #8030
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0085, a3
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0084, a3, #8040
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0085, a3
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0084, a3, #8050
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0085, a3
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0084, a3, #8060
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0085, a3
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0084, a3, #8070
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0085, a3
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0084, a3, #8060
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0085, a3
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0084, a3, #8050
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0085, a3
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0084, a3, #8040
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0085, a3
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0084, a3, #8030
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0085, a3
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0084, a3, #8020
arpvol2lp
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0085, a3
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0084, a3, #8010
	dw #0080, arpvol2lp


arpvol3
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0085, g3
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0084, g3, #8020
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0085, g3
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0084, g3, #8030
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0085, g3
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0084, g3, #8040
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0085, g3
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0084, g3, #8050
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0085, g3
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0084, g3, #8060
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0085, g3
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0084, g3, #8070
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0085, g3
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0084, g3, #8060
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0085, g3
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0084, g3, #8050
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0085, g3
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0084, g3, #8040
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0085, g3
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0084, g3, #8030
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0085, g3
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0084, g3, #8020
arpvol3lp
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0085, g3
	db #01
	db #01
	dw #0000, #0085, c4
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0084, g3, #8010
	dw #0080, arpvol3lp
	
	
arpvol4
	db #01
	dw #0000, #0085, b3
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0085, g3
	db #01
	db #01
	dw #0000, #0085, b3
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0084, g3, #8020
	db #01
	db #01
	dw #0000, #0085, b3
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0085, g3
	db #01
	db #01
	dw #0000, #0085, b3
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0084, g3, #8030
	db #01
	db #01
	dw #0000, #0085, b3
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0085, g3
	db #01
	db #01
	dw #0000, #0085, b3
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0084, g3, #8040
	db #01
	db #01
	dw #0000, #0085, b3
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0085, g3
	db #01
	db #01
	dw #0000, #0085, b3
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0084, g3, #8050
	db #01
	db #01
	dw #0000, #0085, b3
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0085, g3
	db #01
	db #01
	dw #0000, #0085, b3
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0084, g3, #8060
	db #01
	db #01
	dw #0000, #0085, b3
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0085, g3
	db #01
	db #01
	dw #0000, #0085, b3
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0084, g3, #8070
	db #01
	db #01
	dw #0000, #0085, b3
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0085, g3
	db #01
	db #01
	dw #0000, #0085, b3
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0084, g3, #8060
	db #01
	db #01
	dw #0000, #0085, b3
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0085, g3
	db #01
	db #01
	dw #0000, #0085, b3
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0084, g3, #8050
	db #01
	db #01
	dw #0000, #0085, b3
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0085, g3
	db #01
	db #01
	dw #0000, #0085, b3
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0084, g3, #8040
	db #01
	db #01
	dw #0000, #0085, b3
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0085, g3
	db #01
	db #01
	dw #0000, #0085, b3
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0084, g3, #8030
	db #01
	db #01
	dw #0000, #0085, b3
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0085, g3
	db #01
	db #01
	dw #0000, #0085, b3
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0084, g3, #8020
arpvol4lp
	db #01
	db #01
	dw #0000, #0085, b3
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0085, g3
	db #01
	db #01
	dw #0000, #0085, b3
	db #01
	db #01
	dw #0000, #0085, d4
	db #01
	db #01
	dw #0000, #0084, g3, #8010
	dw #0080, arpvol4lp
	
;************************************************************************************************************************************************